CREATE OR REPLACE FUNCTION impl.assert_user_is_here(
    i_uid bigint
) RETURNS void AS $$
DECLARE
BEGIN
    IF NOT EXISTS (
        SELECT 1
          FROM mail.users
         WHERE uid = i_uid
           AND is_here
    ) THEN
        RAISE EXCEPTION 'User is not here, uid: %', i_uid
              USING HINT = 'Probably transfered to different shard, get new DSN from sharpei',
                   ERRCODE = 'MDBA1',
                   TABLE = 'mail.users';
    END IF;
END;
$$ LANGUAGE plpgsql;