CREATE OR REPLACE FUNCTION impl.create_base_filters(
    i_uid    filters.rules.uid%type
) RETURNS VOID AS $$
DECLARE
    v_spam_fid integer;
    v_rule_id filters.rules.rule_id%type;
BEGIN
    -- rule: Spam
    v_spam_fid := code.get_folder_fid(i_uid, 'spam');

    v_rule_id := impl.new_rule(
        i_new_id => NULL,
        i_uid => i_uid,
        i_name => 'Spam',
        i_enabled => TRUE,
        i_stop => TRUE,
        i_last => FALSE,
        i_type => 'system'
    );

    INSERT INTO filters.actions (
        uid, rule_id, oper, param
    ) VALUES (
        i_uid, v_rule_id, 'move', v_spam_fid
    );

    INSERT INTO filters.conditions (
        uid, rule_id, field_type, field, pattern, oper, link
    ) VALUES
    ( i_uid, v_rule_id, 'flag', 'nospam', DEFAULT, 'matches', 'and' ),
    ( i_uid, v_rule_id, 'header', 'X-Yandex-Spam', '4', 'contains', 'or' ),
    ( i_uid, v_rule_id, 'header', 'X-Spam-Flag', 'YES', 'contains', 'or' );

    -- rule: drop exchange mails (MPROTO-3843, MAILDEV-1027)
    v_rule_id := impl.new_rule(
        i_new_id => NULL,
        i_uid => i_uid,
        i_name => '_EXCHANGE_FILTER_',
        i_enabled => TRUE,
        i_stop => TRUE,
        i_last => FALSE,
        i_type => 'system'
    );

    INSERT INTO filters.actions (
        uid, rule_id, oper
    ) VALUES (
        i_uid, v_rule_id, 'delete'
    );

    INSERT INTO filters.conditions (
        uid, rule_id, field_type, field, pattern, oper
    ) VALUES (
        i_uid, v_rule_id, 'header', 'Y-Exchange-Calendar', 'Yes', 'matches'
    );
END;
$$ language 'plpgsql';
