CREATE OR REPLACE FUNCTION impl.json_merge(
    data json,
    merge_data json
) RETURNS json AS $$
    SELECT ('{' || string_agg(to_json(key) || ':' || value, ',') || '}')::json
      FROM (
          WITH to_merge AS (SELECT * FROM json_each(merge_data))
        SELECT *
          FROM json_each(data)
         WHERE key NOT IN (SELECT key FROM to_merge)
         UNION ALL
        SELECT * FROM to_merge
    ) t;
$$ LANGUAGE SQL IMMUTABLE;
