
CREATE OR REPLACE FUNCTION impl.log_change(
    i_uid          bigint,
    i_request_info impl.request_info,
    i_revision     bigint,
    i_type         mail.change_type,
    i_changed      impl.changed_with_fids,
    i_counters     impl.changelog_counters,
    i_args         jsonb DEFAULT NULL,
    i_quiet        boolean DEFAULT NULL
) RETURNS void AS $$
DECLARE
    v_cid      bigint;
BEGIN
    v_cid := impl.insert_changelog(
        i_uid              => i_uid,
        i_request_info     => i_request_info,
        i_revision         => i_revision,
        i_type             => i_type,
        i_changed          => i_changed.changed,
        i_args             => i_args,
        i_fresh_count      => i_counters.fresh_count,
        i_useful_new_count => i_counters.useful_new_count,
        i_quiet            => i_quiet
    );
    IF impl.is_useful_change_for_shared_queue(i_type) THEN
        IF impl.is_change_in_folder(i_type) THEN
            INSERT INTO mail.shared_folder_change_queue
                  (uid, subscription_id, cid)
            SELECT uid, subscription_id, v_cid
              FROM mail.shared_folder_subscriptions
             WHERE uid = i_uid
               AND fid = ANY(i_changed.changed_fids)
               AND NOT impl.is_discontinued_subscription(state);
        ELSE
            INSERT INTO mail.shared_folder_change_queue
                  (uid, subscription_id, cid)
            SELECT uid, subscription_id, v_cid
              FROM mail.shared_folder_subscriptions
             WHERE uid = i_uid
               AND NOT impl.is_discontinued_subscription(state);
        END IF;
    END IF;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION impl.log_change(
    i_uid          bigint,
    i_request_info impl.request_info,
    i_revision     bigint,
    i_type         mail.change_type,
    i_changed      impl.changed_with_fids,
    i_args         jsonb DEFAULT NULL,
    i_quiet        boolean DEFAULT NULL
) RETURNS void AS $$
SELECT impl.log_change(
    i_uid          => i_uid,
    i_request_info => i_request_info,
    i_revision     => i_revision,
    i_type         => i_type,
    i_changed      => i_changed,
    i_counters     => impl.get_changelog_counters(i_uid),
    i_args         => i_args,
    i_quiet        => i_quiet);
$$ LANGUAGE SQL;

DROP DOMAIN IF EXISTS impl.not_change_in_folder_change_type;

CREATE DOMAIN impl.not_change_in_folder_change_type AS mail.change_type
   CONSTRAINT use_log_change__with_changed_with_fids_signature
        CHECK (
            VALUE IS NOT NULL
            AND
            NOT impl.is_change_in_folder(VALUE)
        );


CREATE OR REPLACE FUNCTION impl.log_change(
    i_uid           bigint,
    i_request_info  impl.request_info,
    i_revision      bigint,
    i_type          impl.not_change_in_folder_change_type,
    i_counters      impl.changelog_counters,
    i_changed       jsonb,
    i_args          jsonb,
    i_quiet         boolean DEFAULT NULL
) RETURNS void AS $$
SELECT impl.log_change(
    i_uid          => i_uid,
    i_request_info => i_request_info,
    i_revision     => i_revision,
    i_type         => i_type,
    i_changed      => ('{}'::int[], i_changed)::impl.changed_with_fids,
    i_counters     => i_counters,
    i_args         => i_args,
    i_quiet        => i_quiet);
$$ LANGUAGE SQL;


CREATE OR REPLACE FUNCTION impl.log_change(
    i_uid           bigint,
    i_request_info  impl.request_info,
    i_revision      bigint,
    i_type          impl.not_change_in_folder_change_type,
    i_changed       jsonb DEFAULT NULL,
    i_args          jsonb DEFAULT NULL,
    i_quiet         boolean DEFAULT NULL
) RETURNS void AS $$
SELECT impl.log_change(
    i_uid          => i_uid,
    i_request_info => i_request_info,
    i_revision     => i_revision,
    i_type         => i_type,
    i_changed      => ('{}'::int[], i_changed)::impl.changed_with_fids,
    i_counters     => impl.get_changelog_counters(i_uid),
    i_args         => i_args,
    i_quiet        => i_quiet);
$$ LANGUAGE SQL;
