CREATE OR REPLACE FUNCTION impl.update_dst_tab(
    i_uid            bigint,
    i_dst_tab        mail.tab_types,
    current_revision bigint,
    moved            impl.moved_message[]
) RETURNS void AS $$
DECLARE
    c  record;
    prev_newest_exists boolean;
    update_prev_newest boolean;
    prev_newest_mid    bigint;
    v_real_moved       impl.moved_message[];
BEGIN
    /*
        0. st newest_tit to null if dst_tab is null and exit
        1. update tabs revision
        2. get real moved
        3. update tabs counters
        4. update newest_tit
    */

    IF i_dst_tab IS NULL THEN
        /* set newest_tit to null */
        UPDATE mail.box
           SET newest_tit = NULL
         WHERE uid = i_uid
           AND mid IN (
                SELECT m.mid
                  FROM unnest(moved) m
           );

    ELSE
        -- update new tab revision
        UPDATE mail.tabs
           SET revision = current_revision
         WHERE uid = i_uid
           AND tab = i_dst_tab;

        -- get real moved
        SELECT ARRAY (
            SELECT m
              FROM unnest(moved) m
             WHERE m.src_tab IS DISTINCT FROM i_dst_tab )
        INTO v_real_moved;

        IF v_real_moved IS NULL OR cardinality(v_real_moved) = 0 THEN
            RETURN;
        END IF;

        -- update new tab counters
        UPDATE mail.tabs
           SET message_count = message_count + moved_count,
               message_seen = message_seen + moved_seen,
               message_size = message_size + moved_size,
               attach_count = attach_count + moved_attach_count,
               attach_size = attach_size + moved_attach_size
           FROM (
            SELECT count(*) AS moved_count,
                   sum(m.seen::integer) AS moved_seen,
                   sum(m.size::bigint) AS moved_size,
                   sum((ai).attach_count) AS moved_attach_count,
                   sum((ai).attach_size) AS moved_attach_size
              FROM unnest(v_real_moved) m ) t
          WHERE uid = i_uid
            AND tab = i_dst_tab;

        -- update newest_tit
        FOR c IN (
            SELECT dst_tid,
                   min(newest_moved_date) AS newest_moved_date,
                   min(newest_moved_mid) AS newest_moved_mid
              FROM (
                SELECT m.*,
                       last_value(received_date) over mids_in_thread AS newest_moved_date,
                       last_value(mid) over mids_in_thread AS newest_moved_mid
                  FROM unnest(v_real_moved) m
                 WHERE m.dst_tid IS NOT NULL
                WINDOW mids_in_thread AS (
                       PARTITION BY dst_tid
                       ORDER BY received_date
                       ROWS
                          BETWEEN UNBOUNDED PRECEDING
                              AND UNBOUNDED FOLLOWING)
                   ) m
             GROUP BY dst_tid)
        LOOP
            SELECT mid, received_date < c.newest_moved_date
              INTO prev_newest_mid, update_prev_newest
              FROM mail.box
             WHERE uid = i_uid
               AND tab = i_dst_tab
               AND tid = c.dst_tid
               AND newest_tit = true;
            prev_newest_exists := found;
            IF NOT prev_newest_exists OR update_prev_newest THEN
                UPDATE mail.box
                   SET newest_tit = true
                 WHERE uid = i_uid
                   AND mid = c.newest_moved_mid;
            END IF;
            IF prev_newest_exists AND update_prev_newest THEN
                UPDATE mail.box
                   SET newest_tit = false
                 WHERE uid = i_uid
                   AND mid = prev_newest_mid;
            END IF;
        END LOOP;
    END IF;
END;
$$ LANGUAGE plpgsql;