CREATE OR REPLACE FUNCTION impl.update_labels(
	i_uid            bigint,
	current_revision bigint,
	moved            impl.moved_message[]
) RETURNS void AS $$
    /*
       update labels.message_count base on moved.{src_tid, dst_tid} changes
       currently (as in oracle) we 'hide' labels in `trashable_folders`.
       For sample cases look at tests/features/move_threads_with_labels.feature
    */
    UPDATE mail.labels ld
       SET revision = current_revision,
           message_count = message_count + count_diff,
           message_seen = message_seen + seen_messages
      FROM (
          SELECT lid, sum(lids_sign) AS count_diff, sum(seen_messages) AS seen_messages
            FROM (
              SELECT unnest(lids) lid,
                     lids_sign,
                     seen_messages
                FROM (
                  SELECT m.lids,
                         CASE
                         WHEN dst_tid IS NULL AND src_tid IS NOT NULL
                         THEN -1
                         WHEN dst_tid IS NOT NULL AND src_tid IS NULL
                         THEN 1
                         ELSE 0
                         END AS lids_sign,
                         CASE
                         WHEN seen AND dst_tid IS NULL AND src_tid IS NOT NULL
                         THEN -1
                         WHEN seen AND dst_tid IS NOT NULL AND src_tid IS NULL
                         THEN 1
                         ELSE 0
                         END AS seen_messages
                    FROM unnest(moved) m
                   WHERE cardinality(lids) > 0) um
                WHERE lids_sign != 0 ) ul
           GROUP BY lid) ild
      WHERE uid = i_uid
        AND ld.lid = ild.lid;
$$ LANGUAGE SQL;
