CREATE OR REPLACE FUNCTION impl.update_pop3(
    i_uid            bigint,
    i_moved          impl.moved_message[]
) RETURNS void AS $$
DECLARE
    pop3_fids integer[];
    dummy integer;
BEGIN
    SELECT array_agg(fid)
      INTO pop3_fids
      FROM mail.folders
     WHERE uid = i_uid
       AND (pop3state).initialized;

    IF coalesce(cardinality(pop3_fids), 0) = 0 THEN
        RETURN;
    END IF;

    -- move between popped folders
    UPDATE mail.pop3_box pb
       SET fid = dst_fid
      FROM unnest(i_moved) mpm
     WHERE uid = i_uid
       AND mpm.mid = pb.mid
       AND dst_fid = ANY(pop3_fids);

    -- move from popped folder
    DELETE FROM mail.pop3_box
     WHERE uid = i_uid
       AND mid IN (
        SELECT mid
          FROM unnest(i_moved)
         WHERE dst_fid IS NULL
            OR dst_fid != ANY(pop3_fids));

    -- move to popped folder
    INSERT INTO mail.pop3_box
        (uid, mid, fid, size)
    SELECT
        i_uid, mid, dst_fid, size
      FROM unnest(i_moved) m
     WHERE dst_fid = ANY(pop3_fids)
       AND NOT EXISTS (
          SELECT 1
            FROM mail.pop3_box o
           WHERE o.uid = i_uid
             AND o.mid = m.mid);

END;
$$ LANGUAGE plpgsql;