CREATE OR REPLACE FUNCTION impl.update_src_tabs(
    i_uid            bigint,
    current_revision bigint,
    moved            impl.moved_message[]
) RETURNS void AS $$
DECLARE
    v_real_moved     impl.moved_message[];
BEGIN
    /*
        1. update tabs revision
        2. get real moved
        3. update tabs counters
        4. update newest_tit
    */

    -- update tabs revision
    UPDATE mail.tabs t
       SET revision = current_revision
       FROM (
        SELECT tm.*
           FROM (
               SELECT DISTINCT(src_tab)
                 FROM unnest(moved) m
                WHERE src_tab IS NOT NULL
           ) tm
           JOIN mail.tabs te
             ON (te.uid = i_uid AND te.tab = src_tab) ) te
          WHERE uid = i_uid
        AND t.tab = src_tab;

    -- get real moved
    SELECT ARRAY (
        SELECT m
          FROM unnest(moved) m
         WHERE m.src_tab IS NOT NULL
           AND m.src_tab IS DISTINCT FROM m.dst_tab )
    INTO v_real_moved;

    IF v_real_moved IS NULL OR cardinality(v_real_moved) = 0 THEN
        RETURN;
    END IF;

    -- update tabs counters
    UPDATE mail.tabs t
       SET message_count = message_count - moved_count,
           message_seen = message_seen - moved_seen,
           message_size = message_size - moved_size,
           attach_count = attach_count - moved_attach_count,
           attach_size = attach_size - moved_attach_size
       FROM (
        SELECT tm.*
          FROM (
            SELECT src_tab,
                   count(*) AS moved_count,
                   sum(m.seen::integer) AS moved_seen,
                   sum(m.size::bigint) AS moved_size,
                   sum((ai).attach_count) AS moved_attach_count,
                   sum((ai).attach_size) AS moved_attach_size
              FROM unnest(v_real_moved) m
             GROUP BY src_tab) tm
          JOIN mail.tabs te
            ON (te.uid = i_uid AND te.tab = src_tab) ) te
      WHERE uid = i_uid
        AND t.tab = src_tab;

    -- update newest_tit for src tabs
    UPDATE mail.box
       SET newest_tit = true
      FROM (
        SELECT mm.mid AS new_newest_mid
          FROM (
            SELECT src_tab, src_tid
              FROM (
                SELECT src_tab, src_tid
                  FROM unnest(v_real_moved) u
                 WHERE old_newest_tit = true
                 GROUP BY src_tab, src_tid) td
              JOIN mail.threads t
                ON (t.uid = i_uid AND tid = src_tid)) td,
          LATERAL (
            SELECT mid
              FROM mail.box
             WHERE uid = i_uid
               AND tab = td.src_tab
               AND tid = td.src_tid
             ORDER BY received_date DESC
             LIMIT 1) mm) mn_tit
    WHERE uid = i_uid
      AND mid = new_newest_mid;

END;
$$ LANGUAGE plpgsql;