CREATE OR REPLACE FUNCTION impl.acquire_current_serials(
    i_uid bigint
) RETURNS mail.serials AS $$
DECLARE
    v_row mail.serials;
BEGIN
    SELECT *
      FROM mail.serials
     WHERE uid = i_uid
       FOR NO KEY UPDATE
      INTO v_row;
    IF NOT found THEN
        RAISE EXCEPTION 'No serials selected, uid: %', i_uid
              USING HINT = 'Probably user doesn''t exists',
                   TABLE = 'mail.serials';
    END IF;

    PERFORM impl.assert_user_is_here(i_uid);

    RETURN v_row;
END
$$ LANGUAGE plpgsql;
