CREATE OR REPLACE FUNCTION impl.store_deleted_message(
    i_uid        bigint,
    i_coords     impl.store_deleted_coordinates,
    i_headers    impl.store_headers,
    i_recipients mail.recipient[],
    i_attaches   mail.attach[],
    i_mime       mail.mime_part[]
) RETURNS impl.store_deleted_result AS $$
DECLARE
    v_mid             bigint;
    current_revision  bigint;

    v_mid_serial  bigint;
BEGIN
    UPDATE mail.serials
       SET next_revision = next_revision + 1,
           next_mid_serial = next_mid_serial + 1
     WHERE uid = i_uid
    RETURNING next_revision - 1, next_mid_serial - 1
      INTO current_revision, v_mid_serial;

    PERFORM impl.assert_user_is_here(i_uid);

    v_mid := impl.make_mid(i_coords.received_date, v_mid_serial);

    INSERT INTO mail.messages
        (uid, mid,
        st_id, size,
        attaches,
        mime,
        attributes,
        subject, firstline,
        hdr_date, hdr_message_id,
        recipients,
        extra_data)
    VALUES
        (i_uid, v_mid,
        i_coords.st_id, i_coords.size,
        -- emulate original store_messages
        -- store empty array as NULL
        nullif(i_attaches, ARRAY[]::mail.attach[]),
        i_mime,
        i_coords.attributes,
        i_headers.subject, i_headers.firstline,
        i_headers.hdr_date, i_headers.hdr_message_id,
        i_recipients,
        i_headers.extra_data);

    INSERT INTO mail.deleted_box
        (uid,
        mid,
        revision,
        info,
        received_date)
    VALUES
        (i_uid,
        v_mid,
        current_revision,
        json_build_object('received_date', i_coords.received_date),
        i_coords.received_date);

    RETURN (
        v_mid,
        current_revision
    )::impl.store_deleted_result;
END;
$$ LANGUAGE plpgsql;
