CREATE OR REPLACE FUNCTION impl.delete_messages_impl(
    i_uid              bigint,
    i_mids             bigint[],
    i_current_revision bigint
) RETURNS impl.moved_message[] AS $$
DECLARE
    deleted_messages impl.moved_message[];
BEGIN
    WITH with_deleted AS (
        DELETE
          FROM mail.box
         WHERE uid = i_uid
           AND mid = ANY(i_mids)
        RETURNING *
    ), affected AS (
        INSERT INTO mail.deleted_box
            (uid, mid, revision, info, received_date)
        SELECT
            uid, mid, i_current_revision, json_build_object('received_date', received_date), received_date
          FROM with_deleted x
    )
    SELECT array_agg((
        um.mid,
        NULL, -- destination fid
        um.fid,
        NULL, um.tid,
        NULL, um.imap_id,
        um.chain,
        um.seen, um.recent,
        um.deleted,
        um.lids,
        mm.size,
        um.received_date,
        um.newest_tif,
        impl.get_attaches_info(mm.attaches),
        hdr_message_id,
        mm.attributes,
        NULL, -- destination tab
        um.tab,
        um.newest_tit
        )::impl.moved_message)
      INTO deleted_messages
      FROM with_deleted um
      JOIN mail.messages mm
        ON (um.mid = mm.mid and mm.uid = i_uid);

    IF deleted_messages IS NULL OR cardinality(deleted_messages) = 0 THEN
        RETURN deleted_messages;
    END IF;

    PERFORM impl.update_src_folders(
        i_uid,
        i_current_revision,
        deleted_messages
    );

    PERFORM impl.update_src_tabs(
        i_uid,
        i_current_revision,
        deleted_messages
    );

    PERFORM impl.update_threads(
        i_uid,
        i_current_revision,
        deleted_messages
    );

    PERFORM impl.update_labels(
        i_uid,
        i_current_revision,
        deleted_messages
    );

    PERFORM impl.update_pop3(
        i_uid,
        deleted_messages
    );

    PERFORM impl.update_counters(
        i_uid,
        i_current_revision,
        deleted_messages
    );

    RETURN deleted_messages;
END;
$$ LANGUAGE plpgsql;
