CREATE OR REPLACE FUNCTION impl.merge_single_settings (
    i_old_settings json,
    i_new_settings json
) RETURNS text AS $$
SELECT
    '"single_settings":' ||
    coalesce (
        impl.json_merge (
            (SELECT (i_old_settings ->> 'single_settings')::json),
            (SELECT (i_new_settings ->> 'single_settings')::json)
        )::text,
        (SELECT i_old_settings ->> 'single_settings')
    );
$$ LANGUAGE sql;
