CREATE OR REPLACE FUNCTION impl.merge_settings (
    i_old_settings json,
    i_new_settings json
) RETURNS json AS $$
DECLARE
    signs text;
    single_settings text;
    result json;
BEGIN
    IF i_old_settings IS NULL THEN
        RETURN i_new_settings;
    ELSE
        SELECT
            impl.merge_signs (
                i_old_settings,
                i_new_settings
            ) INTO signs;
        SELECT
            impl.merge_single_settings (
                i_old_settings,
                i_new_settings
            ) INTO single_settings;
        SELECT
            ('{' || coalesce(
                signs || ',' || single_settings, signs, single_settings, '') || '}'
            )::json INTO result;
        RETURN result;
    END IF;
END;
$$ LANGUAGE plpgsql;
