CREATE OR REPLACE FUNCTION impl.settings_difference (
    i_settings jsonb,
    i_subtrahend text[] 
) RETURNS jsonb AS $$
DECLARE
    result jsonb;
    single_settings jsonb;
BEGIN
    IF i_subtrahend IS NULL OR i_settings IS NULL THEN
        RETURN i_settings;
    ELSE
        SELECT coalesce(jsonb_object(array_agg(key), array_agg(value)), '{}'::jsonb)
          FROM (
            SELECT *
              FROM jsonb_each_text(i_settings -> 'single_settings')
             WHERE key <> ALL(i_subtrahend)
          ) AS json_single_settings INTO single_settings;
          
        SELECT jsonb_set(i_settings, '{single_settings}', single_settings, false) INTO result;
        RETURN result;
    END IF;
END;
$$ LANGUAGE plpgsql;
