def basejob = freeStyleJob("ora2pg-template") {
    description('Шаблон с общими параметрами')
    logRotator(-1, 15, -1, 1)

    parameters {
        labelParam('ENV_LABEL') {
            defaultValue('mail_ora2pg')
            description('mail_ora2pg for prod, mail_ora2pg_test for testing')
        }
    }
    wrappers {
        colorizeOutput()
    }
}

freeStyleJob("ora2pg-transfer") {
    description('Перенос пользователя между базами.')
    using(basejob.name)

    parameters {
        stringParam('LOGIN', '', 'User login')
        stringParam('TO_DB', 'postgre:7', 'Shard ID in sharddb to register user in for postgre ["postgre:123" where 123 is shard_id], or dsn (with user) for oracle [oracle:ymail/ympass@mdb302]')
        booleanParam('DO_ALLOW_INITED', true, 'Разрешать ли перенос для уже инициализированных в шарпее пользователей?')
        booleanParam('DO_UPDATE_MAIL_MIGRATION', false, 'Обновлять ли настройки mail_migration и mail_migration_ts?')
        booleanParam('DO_FILL_CHANGE_LOG', true, 'Заполнять ли change_log перенесенными письмами?')
        booleanParam('DO_POP3_ENABLED', false, 'Переносить ли POP3 данные пользователей?')
    }

    steps {
        shell('''
            if ! ${DO_ALLOW_INITED} ; then
                DISALLOW_INITED='--disallow_inited'
            fi
            if ${DO_UPDATE_MAIL_MIGRATION} ; then
                UPDATE_MAIL_MIGRATION='--update_mail_migration'
            fi
            if ${DO_FILL_CHANGE_LOG} ; then
                FILL_CHANGE_LOG='--fill_change_log'
            fi
            if ${DO_POP3_ENABLED} ; then
                POP3_ENABLED='--pop3_enabled'
            fi
            . /etc/oraprofile; yamail-transfer -e ${ENV_NAME} -v --login=${LOGIN} --to_db ${TO_DB} ${DISALLOW_INITED} ${UPDATE_MAIL_MIGRATION} ${FILL_CHANGE_LOG} ${POP3_ENABLED}
        ''')
    }

    publishers {
        buildDescription('.', '${LOGIN} -> ${TO_DB}')
    }
}


freeStyleJob("ora2pg-copy_user") {
    description('Копирование данных между базами. Данные целевого пользователя (TO_ID в TO_DB) будут удалены!')
    using(basejob.name)

    parameters {
        stringParam('FROM_DB', 'oracle:ymail/ympass@mdb302', 'Shard ID in sharddb to register user in for postgre, or dsn (with user) for oracle')
        stringParam('FROM_ID', '', 'SUID for oracle, UID for postgre')
        stringParam('TO_DB', 'postgre:1', 'Shard ID in sharddb to register user in for postgre, or dsn (with user) for oracle')
        stringParam('TO_ID', '', 'SUID for oracle, UID for postgre')
        booleanParam('DO_FILL_CHANGE_LOG', true, 'Заполнять ли change_log перенесенными письмами?')
    }

    steps {
        shell('''
            if ${DO_FILL_CHANGE_LOG} ; then
                FILL_CHANGE_LOG='--fill_change_log'
            fi
                . /etc/oraprofile; yamail-copy-user -e ${ENV_NAME} -v --from_db "${FROM_DB}" --from_id ${FROM_ID} --to_db "${TO_DB}" --to_id ${TO_ID} --force ${FILL_CHANGE_LOG}
        ''')
    }
}

freeStyleJob("ora2pg-restore_user") {
    description('Восстановление пользователя в oracle. Для обратного переноса использовать джобу ora2pg-package-transfer.')
    using(basejob.name)

    parameters {
        stringParam('LOGIN', '', 'User login')
    }

    steps {
        shell('''
                . /etc/oraprofile; yamail-restore-user -e ${ENV_NAME} -v --login=${LOGIN}
        ''')
    }
}

freeStyleJob("ora2pg-steal_users") {
    description('Копирование пользователей из oracle в пользователей pg.')
    using(basejob.name)

    parameters {
        stringParam('SHARD_ID_PARAM', '--shard_id=1', 'Shard ID in sharddb to register user in. If not given, will ask sharddb with \'SELECT * from code.generate_shard_id(:uid);\'')
        textParam('LOGINS', 'from_login:to_login', 'Список пар для копирования (откуда:куда)')
    }

    steps {
        shell('''
        sudo cat /dev/null > file.txt

        for COUPLE in ${LOGINS}
        do
            sudo echo ${COUPLE} >> file.txt
        done
        ''')
        shell('''
                . /etc/oraprofile; yamail-steal-users -e ${ENV_NAME} -v file.txt
        ''')
    }
}

def unstable_basejob = freeStyleJob("ora2pg-package-template") {
    description('Шаблон с общими параметрами для скриптов тестирования переноса')
    logRotator(-1, 15, -1, 1)

    label('mail_ora2pg_test_unstable')
    parameters {
        stringParam('TRANSFER_PKG', '', 'yamail-ora2pg package version to be installed, for instance: yamail-ora2pg-0.1.3-2.noarch')
    }

    steps {
        shell('''
            sudo yum remove -y yamail-ora2pg
            for n in {1..5}; do sudo yum install -y $TRANSFER_PKG && break; sleep $((n * 60)); done
        ''')

    }

    wrappers {
        colorizeOutput()
    }
}

freeStyleJob("ora2pg-package-transfer") {
    description('''
        Перенос пользователя между базами по версии пакета. Используется для тестирования переноса.
        Для использования "стабильной" версии переноса используйте джоб "ora2pg-transfer".
    ''')
    using(unstable_basejob.name)

    parameters {
        stringParam('LOGIN', '', 'User login')
        stringParam('TO_DB', 'postgre:1', 'Shard ID in sharddb to register user in for postgre ["postgre:123" where 123 is shard_id], or dsn (with user) for oracle [oracle:ymail/ympass@mdb302]')
        booleanParam('DO_ALLOW_INITED', true, 'Разрешать ли перенос для уже инициализированных в шарпее пользователей?')
        booleanParam('DO_UPDATE_MAIL_MIGRATION', false, 'Обновлять ли настройки mail_migration и mail_migration_ts?')
        booleanParam('DO_FILL_CHANGE_LOG', true, 'Заполнять ли change_log перенесенными письмами?')
    }

    steps {
        shell('''
            if ! ${DO_ALLOW_INITED} ; then
                DISALLOW_INITED='--disallow_inited'
            fi
            if ${DO_UPDATE_MAIL_MIGRATION} ; then
                UPDATE_MAIL_MIGRATION='--update_mail_migration'
            fi
            if ${DO_FILL_CHANGE_LOG} ; then
                FILL_CHANGE_LOG='--fill_change_log'
            fi
            . /etc/oraprofile; yamail-transfer -e ${ENV_NAME} -v --login=${LOGIN} --to_db ${TO_DB} ${DISALLOW_INITED} ${UPDATE_MAIL_MIGRATION} ${FILL_CHANGE_LOG}
        ''')
    }

    publishers {
        buildDescription('.', '${LOGIN} -> ${TO_DB}')
    }
}

freeStyleJob("transfer_user_back_to_oracle") {
    description('''
        Перенос пользователя в оракловую базу. Ручка предназначена для magic.
        Более общая ручка для переноса: "ora2pg-transfer".
    ''')
    logRotator(-1, 15, -1, 1)

    parameters {
        labelParam('ENV_LABEL') {
            defaultValue('mail_ora2pg')
            description('mail_ora2pg for prod, mail_ora2pg_test for testing')
        }
        stringParam('LOGIN', '', 'User login')
        stringParam('TO_MDB', 'mdb320', 'В какую базу нести пользователя?')

        booleanParam('DO_FILL_CHANGE_LOG', true, '''
            Заполнять ли change_log перенесенными письмами?
            Актуально, пока не будет сделан умный переиндексатор в поиске по почте
        ''')
    }

    steps {
        shell('''
            if ${DO_FILL_CHANGE_LOG} ; then
                FILL_CHANGE_LOG='--fill_change_log'
            fi
            TO_DB="oracle:$TO_MDB"
            . /etc/oraprofile; yamail-transfer -e ${ENV_NAME} -v --login=${LOGIN} --to_db ${TO_DB} ${FILL_CHANGE_LOG}
        ''')
    }

    wrappers {
        colorizeOutput()
    }

    publishers {
        buildDescription('.', '${LOGIN} -> ${TO_DB}')
    }
}
