#!/bin/bash
set -x

dsn="dbname=${1}_migrations"

set -e

echo "drop database if exists ${1}_migrations" | psql
echo "create database ${1}_migrations" | psql

python scripts/make_db_users.py "$dsn"

TARGET=$(ls migrations | cut -d_ -f1 | sed 's/V//g' | sort -g | tail -n1 | sed 's/^0*//')
if ls migrations/ | grep -E "V0*${TARGET}__" | grep -q NONTRANSACTIONAL
then
    STARGET=$(ls migrations | grep -v NONTRANSACTIONAL | cut -d_ -f1 | sed 's/V//g' | sort -g | tail -n1 | sed 's/^0*//')
else
    STARGET=$TARGET
fi
for i in $(seq $(( $STARGET - 1 )))
do
    pgmigrate -d "$(pwd)" -t "$i" -c "$dsn" -a beforeAll:"$(pwd)"/constants migrate
done
if [ "$STARGET" != "$TARGET" ]
then
    for i in $(seq $STARGET $TARGET)
    do
        pgmigrate -d "$(pwd)" -t "$i" -c "$dsn" -a \
            beforeAll:"$(pwd)"/drops/,beforeAll:"$(pwd)"/constants,afterAll:"$(pwd)"/impl/,afterAll:"$(pwd)"/code,afterAll:"$(pwd)"/util,afterAll:"$(pwd)"/grants \
            migrate
    done
else
    pgmigrate -d "$(pwd)" -t "$TARGET" -c "$dsn" -a \
        beforeAll:"$(pwd)"/drops/,beforeAll:"$(pwd)"/constants,afterAll:"$(pwd)"/impl/,afterAll:"$(pwd)"/code,afterAll:"$(pwd)"/util,afterAll:"$(pwd)"/grants \
        migrate
fi

pgmigrate -c "$dsn" clean

function dump_db {
    echo "select '-T ' || partition_schemaname || '.' || partition_tablename from unnest('{mail.change_log,mail.doberman_jobs_change_log}'::text[]) t, partman.show_partitions(t) s" | psql -qtAX "$1" | xargs pg_dump -T'public.repl_mon'  -s "$1" > /tmp/$1.sql
}

dump_db ${1}
dump_db ${1}_migrations

diff -C5  /tmp/${1}.sql /tmp/${1}_migrations.sql
