CREATE TYPE mail.tab_types AS ENUM (
    'relevant',
    'news',
    'social'
);

CREATE TABLE mail.tabs (
    uid            bigint  NOT NULL,
    tab            mail.tab_types  NOT NULL,
    revision       bigint  NOT NULL,
    unvisited      boolean  NOT NULL DEFAULT 'no',
    created        timestamp with time zone NOT NULL DEFAULT current_timestamp,

    message_count  integer NOT NULL DEFAULT 0,
    message_seen   integer NOT NULL DEFAULT 0,
    message_size   bigint  NOT NULL DEFAULT 0,
    attach_count   integer NOT NULL DEFAULT 0,
    attach_size    bigint  NOT NULL DEFAULT 0,

    CONSTRAINT check_message_count CHECK (
        message_count >= 0 AND
        message_seen  >= 0 AND
        message_count >= message_seen
    ),
    CONSTRAINT check_message_size CHECK (
        (message_size > 0 AND message_count > 0)
        OR
        (message_size = 0 AND message_count = 0)
    ),
    CONSTRAINT check_attaches CHECK (
        attach_count >= 0 AND
        attach_size >= 0 AND
        attach_size <= message_size
    ),
    CONSTRAINT check_revision CHECK (
        revision > 0
    ),
    CONSTRAINT pk_tabs PRIMARY KEY (uid, tab),
    CONSTRAINT fk_tabs_uid_users FOREIGN KEY (uid)
        REFERENCES mail.users ON DELETE RESTRICT
);

ALTER TABLE mail.box
  ADD COLUMN tab mail.tab_types,
  ADD COLUMN newest_tit boolean,
  ADD CONSTRAINT check_newest_tit_on_not_tabbed CHECK (
      (tab IS NULL AND newest_tit IS NULL)
      OR
      (tab IS NOT NULL AND newest_tit IS NOT NULL)
  ) NOT VALID,
  ADD CONSTRAINT check_newest_tit_on_not_threaded CHECK (
      (tid IS NULL AND (newest_tit IS NULL OR NOT newest_tit))
      OR
      tid IS NOT NULL
  ) NOT VALID;
