CREATE TABLE contacts.subscribed_lists (
    user_id bigint NOT NULL,
    user_type contacts.user_type NOT NULL,
    list_id bigint NOT NULL,
    owner_user_id bigint NOT NULL,
    owner_user_type contacts.user_type NOT NULL,
    owner_list_id bigint NOT NULL,
    revision bigint NOT NULL,

    CONSTRAINT pk_subscribed_lists PRIMARY KEY (user_id, user_type, list_id, owner_user_id, owner_user_type,
            owner_list_id),
    CONSTRAINT fk_subscribed_lists_user_id_user_type_list_id_lists FOREIGN KEY (user_id, user_type, list_id)
        REFERENCES contacts.lists ON DELETE RESTRICT,
    CONSTRAINT check_subscribe_for_itself CHECK(user_id <> owner_user_id OR user_type <> owner_user_type),
    CONSTRAINT check_owner_user_id CHECK(owner_user_id > 0),
    CONSTRAINT check_owner_list_id CHECK(owner_list_id > 0),
    CONSTRAINT check_revision CHECK(revision > 0)
);

CREATE INDEX i_subscribed_lists_user_id_user_type
    ON contacts.subscribed_lists (user_id, user_type);

CREATE INDEX i_subscribed_lists_user_id_user_type_list_id
    ON contacts.subscribed_lists (user_id, user_type, list_id);
