CREATE TYPE contacts.directory_entity_type AS ENUM (
    'department',
    'group',
    'user'
);

CREATE TABLE contacts.directory_entities (
    user_id bigint NOT NULL,
    user_type contacts.user_type NOT NULL,
    directory_entity_id bigint NOT NULL,
    directory_entity_type contacts.directory_entity_type NOT NULL,
    contact_id bigint NOT NULL,
    revision bigint NOT NULL,

    CONSTRAINT pk_directory_entities PRIMARY KEY (user_id, user_type, directory_entity_id, directory_entity_type),
    CONSTRAINT fk_directory_entities_to_contacts FOREIGN KEY (user_id, user_type, contact_id)
        REFERENCES contacts.contacts ON DELETE RESTRICT,
    CONSTRAINT check_directory_entity_id CHECK (
        directory_entity_id > 0
    ),
    CONSTRAINT check_revision CHECK (
        revision > 0
    )
);

CREATE UNIQUE INDEX uk_directory_entities
    ON contacts.directory_entities (user_id, user_type, directory_entity_id, directory_entity_type, contact_id);
