CREATE TABLE IF NOT EXISTS settings.bulk_modification (
    id smallserial UNIQUE NOT NULL,
    name text NOT NULL DEFAULT '',
    create_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT only_one_row CHECK (id = 1)
);

CREATE TABLE IF NOT EXISTS settings.users_for_modify (
    uid bigint NOT NULL,
    is_modified boolean DEFAULT FALSE, 
    CONSTRAINT pk_users_for_modify PRIMARY KEY (uid),
    CONSTRAINT fk_users_for_modify_uid_users FOREIGN KEY (uid) REFERENCES settings.settings ON DELETE CASCADE

);

CREATE INDEX IF NOT EXISTS users_is_modify ON settings.users_for_modify (uid) WHERE is_modified IS FALSE;
