CREATE OR REPLACE FUNCTION contacts.generate_full_name(
    vcard jsonb
) RETURNS text AS $$
DECLARE
    names jsonb;
    name jsonb;
    full_name text;
BEGIN
    names = vcard->'names';
    IF names IS NULL OR jsonb_array_length(names) = 0 THEN
        RETURN NULL;
    END IF;

    name = vcard->'names'->0;
    full_name = array_to_string(array_replace(
        ARRAY[lower(name->>'first'), lower(name->>'middle'), lower(name->>'last')], '', NULL), ' ');

    IF full_name = '' THEN
        RETURN NULL;
    END IF;

    RETURN full_name;
END
$$ LANGUAGE plpgsql IMMUTABLE;

CREATE INDEX CONCURRENTLY IF NOT EXISTS i_contacts_user_id_user_type_full_name
    ON contacts.contacts (user_id, user_type, contacts.generate_full_name(vcard));
