DROP TABLE IF EXISTS settings.users_for_modify;

CREATE TABLE IF NOT EXISTS settings.users_for_init (
    uid bigint NOT NULL,
    is_modified boolean DEFAULT FALSE,
    CONSTRAINT pk_users_for_init PRIMARY KEY (uid),
    CONSTRAINT fk_users_for_init_uid_users FOREIGN KEY (uid) REFERENCES mail.users ON DELETE CASCADE
);

CREATE INDEX IF NOT EXISTS users_is_inited ON settings.users_for_init (uid) WHERE NOT is_modified;

CREATE TABLE IF NOT EXISTS settings.users_for_update (
    uid bigint NOT NULL,
    is_modified boolean DEFAULT FALSE,
    CONSTRAINT pk_users_for_update PRIMARY KEY (uid)
);

CREATE INDEX IF NOT EXISTS users_is_updated ON settings.users_for_update (uid) WHERE NOT is_modified;
