CREATE TYPE mail.user_state AS ENUM (
  'active',
  'inactive',
  'notified',
  'frozen',
  'archived',
  'deleted',
  'special'
);

ALTER TABLE mail.users
  ADD COLUMN state                mail.user_state,
  ADD COLUMN last_state_update    timestamp with time zone,
  ADD COLUMN notifies_count       smallint;

ALTER TABLE mail.users
  ALTER COLUMN state              SET DEFAULT 'active',
  ALTER COLUMN last_state_update  SET DEFAULT current_timestamp,
  ALTER COLUMN notifies_count     SET DEFAULT 0;
