CREATE TYPE mail.archive_state AS ENUM (
    'archivation_in_progress',
    'archivation_complete',
    'archivation_error',
    'restoration_in_progress',
    'restoration_complete',
    'restoration_error'
);

CREATE TABLE mail.archives (
    uid                         bigint NOT NULL,

    version                     integer NOT NULL DEFAULT 1,
    state                       mail.archive_state NOT NULL DEFAULT 'archivation_in_progress',
    revision                    bigint,

    message_count               integer NOT NULL DEFAULT 0,
    restored_message_count      integer NOT NULL DEFAULT 0,

    updated                     timestamptz NOT NULL DEFAULT current_timestamp,
    notice                      text,

    CONSTRAINT pk_archives PRIMARY KEY (uid),
    CONSTRAINT fk_archives_users FOREIGN KEY (uid) REFERENCES mail.users ON DELETE CASCADE,

    CONSTRAINT check_counters CHECK (
        message_count >= 0 AND
        restored_message_count >= 0 
    )
);
