# coding: utf-8

from contextlib import contextmanager
import logging
from psycopg2 import DatabaseError
from mail.pypg.pypg.query_conf import load_from_package
from mail.pypg.pypg.common import transaction, qexec


log = logging.getLogger(__name__)

Q = load_from_package(__package__, __file__)


@contextmanager
def locked_transaction(dsn, uid):
    with transaction(dsn) as conn:
        try:
            cur = qexec(conn, Q.lock_user, uid=uid)
            revision = cur.fetchone()[0]
        except DatabaseError as e:
            log.info('Lock aquisition failed: %r', e)
            raise
        log.info('Lock aquired for uid=%r', uid)
        yield conn, revision
