# coding: utf-8

from six import text_type
import sys

FNV1_INIT = 14695981039346656037
FNV1_PRIME = 1099511628211
MAX64 = 18446744073709551616


def ascii(char):
    """ oracle like ascii function

    returns a dec value regarding utf8 unicode storage

    http://bitbach.wordpress.com/2012/09/11/just-another-discussion-of-unicode-character-conversion-for-oracle/
    http://docs.oracle.com/cd/E11882_01/server.112/e41084/functions013.htm#SQLRF51224
    53647
    """
    assert isinstance(char, text_type), 'expect text type, got: {0}'.format(char)
    if (sys.version_info > (3, 0)):
        bytes_lst = reversed(char.encode('utf-8'))
    else:
        bytes_lst = reversed([ord(c) for c in char.encode('utf-8')])
    return sum([b*(256**i) for i, b in enumerate(bytes_lst)])


def _fnv1(string, char_conv):
    v = FNV1_INIT
    for c in string:
        v = ((v * FNV1_PRIME) % MAX64) ^ char_conv(c)
    return v


def ora_fnv1(string):
    """ FindThreads.fnv1 port

    original function PL/sql

           if length(s) > 0 then
            -- EML-10458
            sl := substrb(lower(trim(s)), 1, 3071);
            for i in 1 .. length(sl) loop
                hval := mod(hval * 1099511628211, 18446744073709551616);
                hval := bitops.bitxor(hval,  ascii(substr(sl, i, 1)));
            end loop;
        end if;
        return hval;

    """
    assert isinstance(string, text_type), 'expect text type object'
    return _fnv1(string.strip().lower(), ascii)


def fnv1(string):
    """ fnv1 with `normal` ascii function"""
    return _fnv1(string, ord)
