-- User dictionaries
-- used in test and transfer

-- name: user_exists
SELECT TRUE
  FROM mail.users
 WHERE uid = :uid

-- name: folders
SELECT *
  FROM mail.folders
 WHERE uid = :uid

-- name: pop3_folders
SELECT *
  FROM mail.folders
 WHERE uid = :uid AND (pop3state).initialized

-- name: labels
SELECT *
  FROM mail.labels
 WHERE uid = :uid

-- name: imap_unsubscribed_folders
SELECT *
  FROM mail.imap_unsubscribed_folders
 WHERE uid = :uid

-- name: user
SELECT here_since, is_here, data_version, is_deleted, purge_date, can_read_tabs,
       state, last_state_update, notifies_count
  FROM mail.users
 WHERE uid = :uid

-- name: shared_fids
SELECT fid
  FROM mail.shared_folders
 WHERE uid = :uid

-- name: shared_folders
SELECT *
  FROM mail.shared_folders
 WHERE uid = :uid

-- name: shared_folder_subscriptions
SELECT *
  FROM mail.shared_folder_subscriptions
 WHERE uid = :uid

-- name: shared_folder_change_queue
SELECT cid
  FROM mail.shared_folder_change_queue
 WHERE uid = :uid
   AND subscription_id = :subscription_id
 ORDER BY cid

-- name: subscribed_folders
SELECT *
  FROM mail.subscribed_folders
 WHERE uid = :uid

-- name: synced_messages
SELECT sm.*
  FROM mail.synced_messages sm
  JOIN mail.box mb
 USING (uid, mid)
 WHERE uid = :uid
   AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)

-- Transfer queries
-- name: mails_dicts
   SELECT mb.mid, mb.fid, mb.tab, mb.tid, imap_id, mb.revision,
          mb.seen, recent, deleted, received_date, lids,
          st_id, mm.size,
          to_json(attributes) as attributes,
          to_json(attaches) as attaches,
          to_json(mime) as mime,
          subject, firstline, hdr_date, hdr_message_id,
          to_json(recipients) as recipients,
          extra_data, pb.mid as pop3_mid,
          ((f.pop3state).initialized and pb.mid is not null) as pop3,
          pb.old_uidl as pop_uidl,
          found_tid,
          thread_rule,
          doom_date
     FROM mail.box mb
     JOIN mail.messages mm
       ON (mb.uid = mm.uid AND mb.mid = mm.mid)
LEFT JOIN mail.pop3_box pb
       ON (mb.uid = pb.uid AND mb.mid = pb.mid)
     JOIN mail.folders f
       ON (mb.uid = f.uid AND mb.fid = f.fid)
    WHERE mb.uid = :uid
      AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
      AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)

-- name: message_references
SELECT mid, type, value
  FROM mail.message_references mr
  JOIN mail.box mb
 USING (uid, mid)
 WHERE mr.uid = :uid
   AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)
UNION ALL
SELECT mid, type, value
  FROM mail.message_references mr
  JOIN mail.deleted_box db
 USING (uid, mid)
 WHERE mr.uid = :uid
   AND (:min_received_date IS NULL OR db.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR db.received_date < :max_received_date)

-- name: threads_messages
SELECT mid, tid, rule, sort_options
  FROM mail.threads_messages tm
 WHERE tm.uid = :uid

-- name: threads_hashes
SELECT DISTINCT tid, namespace, value, uniq_key
  FROM mail.threads_hashes
  JOIN mail.box mb
 USING (uid, tid)
 WHERE uid = :uid
   AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)

--- name: fix_log
SELECT revision, fix_key, fixed, fix_date, db_user
  FROM mail.fix_log
 WHERE uid = :uid

--- name: serials
SELECT next_revision,
       next_mid_serial,
       next_lid,
       next_fid,
       next_owner_subscription_id,
       next_subscriber_subscription_id,
       next_collector_id,
       next_backup_id
  FROM mail.serials s
 WHERE uid = :uid

--- name: default_serials
SELECT next_revision,
       next_mid_serial,
       next_lid,
       next_fid,
       next_owner_subscription_id,
       next_subscriber_subscription_id,
       next_collector_id,
       next_backup_id
  FROM code.default_serials()

-- name: counters
SELECT fresh_count, revision
  FROM mail.counters
 WHERE uid = :uid

-- name: mailish_accounts
SELECT email,
       imap_login,
       imap_server,
       imap_port,
       imap_ssl,
       smtp_login,
       smtp_server,
       smtp_port,
       smtp_ssl,
       last_sync
  FROM mailish.accounts
 WHERE uid = :uid

-- name: mailish_auth_data
SELECT token_id,
       auth_type,
       uuid,
       lock_flag,
       last_valid,
       oauth_app,
       imap_credentials,
       smtp_credentials
  FROM mailish.auth_data
 WHERE uid = :uid

-- name: mailish_folders
SELECT fid,
       imap_path,
       uidvalidity,
       range_start,
       range_end
  FROM mailish.folders
 WHERE uid = :uid

-- name: mailish_messages
SELECT mm.fid,
       mm.imap_id,
       mm.imap_time,
       mm.mid,
       mm.errors
  FROM mailish.messages mm
  JOIN mail.box mb
  USING (uid, mid)
 WHERE uid = :uid
   AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)

-- Filters
-- name: filter_elists
SELECT email, list, created
  FROM filters.elist
 WHERE uid = :uid

-- name: rules_dicts
SELECT rule_id, name,
       enabled, prio,
       stop, created,
       type,
       (SELECT json_agg(c)
          FROM filters.conditions c
         WHERE c.uid=r.uid
           AND c.rule_id = r.rule_id) AS conditions,
       (SELECT json_agg(a)
          FROM filters.actions a
         WHERE a.uid = r.uid
           AND a.rule_id = r.rule_id) AS actions
 FROM filters.rules r
WHERE uid = :uid
ORDER BY prio

-- name: rules_get
SELECT rule_id, name,
       enabled, prio,
       stop, created,
       type
FROM filters.rules
WHERE uid = :uid
AND type = :type
ORDER BY prio

-- Different defaults
-- name: default_folders
SELECT *
  FROM code.default_folders()
 ORDER BY type

-- name: default_labels
SELECT *
  FROM code.default_labels()

-- name: doomed_folder_types
SELECT v
  FROM unnest(enum_range(NULL::mail.folder_types)) AS v
 WHERE code.is_doom_folder(v)

-- name: threaded_folder_types
SELECT v
  FROM unnest(enum_range(NULL::mail.folder_types)) AS v
 WHERE code.is_threaded_folder(v)

-- name: get_purge_steps
-- cast to text, cause psycopg2 don't handle regproc[]
SELECT code.purge_user_steps()::text[]

-- name: get_purge_on_delete_steps
-- cast to text, cause psycopg2 don't handle regproc[]
SELECT code.purge_on_delete_user_steps()::text[]

-- name: violations
SELECT * FROM code.check_counters(:uid)

-- name: folder_path
SELECT code.get_folder_path(:uid, :fid) AS path

-- Tests Helpers
-- name: messages
SELECT mb.mid, fid, tid, tab, imap_id, revision,
       seen, recent, deleted,
       st_id, received_date, hdr_date,
       size, to_json(attaches) as attaches,
       to_json(mime) as mime,
       lids, subject, pop_uidl,
       firstline, hdr_message_id,
       to_json(recipients) as recipients,
       to_json(attributes) as attributes,
       found_tid,
       thread_rule
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid=mm.mid)
 WHERE mb.uid = :uid
   AND mb.fid = :fid
 ORDER BY mb.received_date DESC

-- name: message
SELECT mb.mid, fid, tid, tab, imap_id, revision,
       seen, recent, deleted,
       st_id, received_date,
       size,
       doom_date,
       to_json(attaches) as attaches,
       to_json(mime) as mime,
       to_json(lids) as lids,
       subject, extra_data, hdr_date,
       firstline, hdr_message_id,
       to_json(recipients) as recipients,
       to_json(attributes) as attributes,
       pop_uidl,
       found_tid,
       thread_rule,
       newest_tif, newest_tit
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid=mm.mid)
 WHERE mb.uid = :uid
   AND mb.mid = :mid

-- name: deleted_messages
SELECT mid, revision, deleted_date,
       json_build_object('received_date', info->>'received_date') as info,
       received_date
  FROM mail.deleted_box mb
 WHERE mb.uid = :uid

-- name: deleted_mails
   SELECT mm.mid,
          st_id,
          size,
          to_json(attributes) as attributes,
          to_json(attaches) as attaches,
          to_json(mime) as mime,
          subject,
          firstline,
          hdr_date,
          hdr_message_id,
          to_json(recipients) as recipients,
          extra_data,
          pop_uidl,
          found_tid,
          thread_rule,
          db.revision,
          json_build_object('received_date', db.info->>'received_date') as info,
          db.deleted_date,
          db.received_date
     FROM mail.deleted_box db
     JOIN mail.messages mm
    USING (uid, mid)
    WHERE db.uid = :uid
      AND (:min_received_date IS NULL OR db.received_date >= :min_received_date)
      AND (:max_received_date IS NULL OR db.received_date < :max_received_date)

-- name: storage_delete_queue
SELECT *
  FROM mail.storage_delete_queue
 WHERE uid = :uid

-- name: threads
SELECT mb.mid, fid, mb.tid, mb.tab, mb.revision,
       seen, recent, deleted,
       st_id, received_date,
       size, to_json(attaches) as attaches,
       t.attach_count, t.attach_size,
       lids, subject,
       firstline, hdr_message_id,
       recipients, newest_mid,
       t.message_count,
       t.message_count - t.message_seen AS message_unseen,
       t.revision AS thread_revision,
       labels AS thread_labels
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid = mm.mid)
  JOIN mail.threads t
    ON (mb.uid = t.uid AND mb.tid = t.tid)
 WHERE mb.uid = :uid
   AND mb.fid = :fid
   AND mb.newest_tif = true
 ORDER BY received_date DESC

-- name: imap_messages
SELECT mb.mid, imap_id, revision, chain,
       seen, recent, deleted,
       st_id, received_date,
       size, lids
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid=mm.mid)
 WHERE mb.uid = :uid
   AND mb.fid = :fid
 ORDER BY imap_id

-- name: mids_with_lids
SELECT mid
  FROM mail.box
 WHERE mail.ulids(uid, lids) && mail.ulids(:uid, :lids)
   AND cardinality(lids)>0
 LIMIT :limit

-- name: mids_without_lids
SELECT mid
  FROM mail.box
 WHERE uid = :uid
   AND NOT lids && :lids
 LIMIT :limit

-- name: references
SELECT m.value
  FROM mail.message_references m
 WHERE uid = :uid AND mid = :mid

-- name: changelog
SELECT cid, revision, type, changed, db_user, session_key, x_request_id,
       useful_new_count, arguments, quiet
  FROM mail.change_log
 WHERE uid = :uid
 ORDER BY revision, cid

-- name: chained_log
SELECT revision, mid,
       chained_id, imap_id,
       distance
  FROM mail.chained_log
 WHERE uid = :uid
   AND fid = :fid
   AND revision >= :revision

-- name: pop3_box
SELECT mid, fid, size, old_uidl
  FROM mail.pop3_box p3b
 WHERE p3b.uid = :uid

-- name: messages_table
SELECT *
  FROM mail.messages
 WHERE uid = :uid

-- name: message_count
SELECT SUM(count) as count
  FROM (
    SELECT SUM(message_count) as count
      FROM mail.folders
     WHERE uid=:uid
    UNION
    SELECT COUNT(*) as count
      FROM mail.deleted_box
     WHERE uid=:uid
  ) as u

-- name: chained_rec_count
SELECT COUNT(*)
  FROM mail.chained_log
 Where uid = :uid

-- name: mailish_data
SELECT *
  FROM mailish.messages
 WHERE uid = :uid
   AND mid = :mid

-- name: mailish_count
SELECT COUNT(*) as count
  FROM mailish.messages
 WHERE uid = :uid
   AND fid = :fid

-- name: mailish_auth_count
SELECT COUNT(*) as count
  FROM mailish.auth_data
 WHERE uid = :uid

 -- name: mailish_security_locks_count
SELECT COUNT(*) as count
  FROM mailish.auth_data
 WHERE uid = :uid
   AND lock_flag = true

-- name: mailish_folder
SELECT *
  FROM mailish.folders
 WHERE uid = :uid
   AND fid = :fid

-- name: mailish_folders_count
SELECT COUNT(*) as count
  FROM mailish.folders
 WHERE uid = :uid

-- name: mailish_data_by_imap_coords
SELECT *
  FROM mailish.messages
 WHERE uid = :uid
   AND fid = :fid
   AND imap_id = :imap_id

-- name: mailish_auth_data_by_token_id
SELECT *
  FROM mailish.auth_data
 WHERE uid = :uid
   AND token_id = :token_id

-- name: windat_messages
SELECT mid, st_id, hid, windat
  FROM mail.windat_messages
  JOIN mail.box mb
 USING (uid, mid)
 WHERE uid = :uid
   AND (:min_received_date IS NULL OR mb.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR mb.received_date < :max_received_date)
UNION ALL
SELECT mid, st_id, hid, windat
  FROM mail.windat_messages
  JOIN mail.deleted_box db
 USING (uid, mid)
 WHERE uid = :uid
   AND (:min_received_date IS NULL OR db.received_date >= :min_received_date)
   AND (:max_received_date IS NULL OR db.received_date < :max_received_date)

-- name: unsubscribe_tasks
SELECT *
  FROM mail.unsubscribe_tasks
 WHERE owner_uid = :uid

-- name: folder_archivation_rules
SELECT fid, revision,
       archive_type, keep_days,
       created, max_size
  FROM mail.folder_archivation_rules
 WHERE uid = :uid

--name: get_settings
SELECT *
  FROM settings.settings
WHERE uid = :uid

--name: get_contacts_user
SELECT user_id, user_type, here_since, is_here, is_deleted,
       is_directory_sync_enabled,
       directory_synced_revision,
       directory_last_event_id,
       directory_last_synced_event_id,
       directory_last_sync_date,
       directory_pending_events_count
  FROM contacts.users
 WHERE user_id = :user_id
   AND user_type = :user_type

--name: get_contacts_serials
SELECT user_id, user_type, next_list_id, next_contact_id, next_tag_id, next_revision, next_email_id
  FROM contacts.serials
 WHERE user_id = :user_id
   AND user_type = :user_type

--name: get_contacts_list_by_type_and_name
SELECT user_id, user_type, list_id, revision, name, type, unique_type
  FROM contacts.lists
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND type = :list_type
   AND name = :list_name

--name: get_contacts_list_by_id
SELECT user_id, user_type, list_id, revision, name, type, unique_type
  FROM contacts.lists
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND list_id = :list_id

--name: get_contacts_tag_by_type_and_name
SELECT user_id, user_type, tag_id, revision, name, type
  FROM contacts.tags
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND type = :tag_type
   AND name = :tag_name

--name: get_contacts_tag_by_id
SELECT user_id, user_type, tag_id, revision, name, type
  FROM contacts.tags
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND tag_id = :tag_id

--name: get_contact_by_id
SELECT user_id, user_type, contact_id, list_id, revision, format, vcard, uri
  FROM contacts.contacts
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND contact_id = :contact_id

-- name: get_contact_tag
SELECT user_id, user_type, contact_id, tag_id, revision
  FROM contacts.contacts_tags
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND contact_id = :contact_id
   AND tag_id = :tag_id

-- name: get_shared_contacts_list_to
SELECT user_id, user_type, list_id, client_user_id, client_user_type, revision
  FROM contacts.shared_lists
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND list_id = :list_id
   AND client_user_id = :client_user_id
   AND client_user_type = :client_user_type

-- name: get_subscribed_contacts_list_to
SELECT user_id, user_type, list_id, owner_user_id, owner_user_type, owner_list_id, revision
  FROM contacts.subscribed_lists
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND list_id = :list_id
   AND owner_user_id = :owner_user_id
   AND owner_user_type = :owner_user_type
   AND owner_list_id = :owner_list_id

-- name: get_contacts_change_log
SELECT change_id, revision, type, arguments, changed, x_request_id, revert_change_id, db_user
  FROM contacts.change_log
 WHERE user_id = :user_id
   AND user_type = :user_type
 ORDER BY change_id

--name: get_contacts_email_by_id
SELECT user_id, user_type, email_id, contact_id, revision, email, type, label
  FROM contacts.emails
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND email_id = :email_id

-- name: get_contacts_email_tag
SELECT user_id, user_type, email_id, contact_id, tag_id, revision
  FROM contacts.emails_tags
 WHERE user_id = :user_id
   AND user_type = :user_type
   AND email_id = :email_id
   AND tag_id = :tag_id

--name: get_passport_user_contacts_users
SELECT user_id, user_type, here_since, is_here, is_deleted
  FROM contacts.users
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_serials
SELECT user_id, user_type, next_list_id, next_contact_id, next_tag_id, next_revision, next_email_id
  FROM contacts.serials
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_lists
SELECT user_id, user_type, list_id, revision, name, type, unique_type
  FROM contacts.lists
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_tags
SELECT user_id, user_type, tag_id, revision, name, type
  FROM contacts.tags
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_contacts
SELECT user_id, user_type, contact_id, list_id, revision, format, vcard, uri
  FROM contacts.contacts
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_emails
SELECT user_id, user_type, email_id, contact_id, revision, email, type, label
  FROM contacts.emails
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_contacts_tags
SELECT user_id, user_type, contact_id, tag_id, revision
  FROM contacts.contacts_tags
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_emails_tags
SELECT user_id, user_type, contact_id, email_id, tag_id, revision
  FROM contacts.emails_tags
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_contacts_shared_lists
SELECT user_id, user_type, list_id, client_user_id, client_user_type, revision
  FROM contacts.shared_lists
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

--name: get_passport_user_default_contacts_list_id
SELECT list_id
  FROM contacts.lists
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type
   AND type = 'personal'::contacts.list_type
   AND unique_type = true

--name: get_passport_user_contacts_subscribed_lists
SELECT user_id, user_type, list_id, owner_user_id, owner_user_type, owner_list_id, revision
  FROM contacts.subscribed_lists
 WHERE user_id = :uid
   AND user_type = 'passport_user'::contacts.user_type

-- name: tabs
SELECT *
  FROM mail.tabs
 WHERE uid = :uid

-- name: messages_by_tab
SELECT mb.mid, fid, tid, tab, imap_id, revision,
       seen, recent, deleted,
       st_id, received_date, hdr_date,
       size, to_json(attaches) as attaches,
       to_json(mime) as mime,
       lids, subject, pop_uidl,
       firstline, hdr_message_id,
       to_json(recipients) as recipients,
       to_json(attributes) as attributes,
       found_tid,
       thread_rule
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid=mm.mid)
 WHERE mb.uid = :uid
   AND mb.tab = :tab
 ORDER BY mb.received_date DESC

-- name: threads_by_tab
SELECT mb.mid, fid, mb.tid, mb.tab, mb.revision,
       seen, recent, deleted,
       st_id, received_date,
       size, to_json(attaches) as attaches,
       t.attach_count, t.attach_size,
       lids, subject,
       firstline, hdr_message_id,
       recipients, newest_mid,
       t.message_count,
       t.message_count - t.message_seen AS message_unseen,
       t.revision AS thread_revision,
       labels AS thread_labels
  FROM mail.box mb
  JOIN mail.messages mm
    ON (mb.uid = mm.uid AND mb.mid = mm.mid)
  JOIN mail.threads t
    ON (mb.uid = t.uid AND mb.tid = t.tid)
 WHERE mb.uid = :uid
   AND mb.tab = :tab
   AND mb.newest_tit = true
 ORDER BY received_date DESC

-- name: collectors
SELECT collector_id, metadata
  FROM mail.collectors
 WHERE uid = :uid

-- name: collectors_metadata
SELECT src_uid, auth_token, creation_ts, root_folder_id, label_id
  FROM mail.collectors, jsonb_to_record(metadata) as meta (
         src_uid bigint,
         auth_token text,
         creation_ts timestamp with time zone,
         root_folder_id integer,
         label_id integer)
 WHERE uid = :uid
   AND collector_id = :collector_id

-- name: attach_counters
SELECT has_attaches_count,
       has_attaches_seen
  FROM mail.counters
 WHERE uid = :uid

-- name: stats_users_info
SELECT *
  FROM stats.users_info
 WHERE uid = :uid

-- name: get_bulk_task_modify_settings
SELECT name
  FROM settings.bulk_modification
 WHERE id = 1

-- name: get_user_for_update_settings
SELECT is_modified
  FROM settings.users_for_update
 WHERE uid = :uid

-- name: get_user_for_init_settings
SELECT is_modified
  FROM settings.users_for_init
 WHERE uid = :uid

-- name: backups
SELECT *
  FROM backup.backups
 WHERE uid = :uid
 ORDER BY created DESC

-- name: restores
SELECT *
  FROM backup.restores
 WHERE uid = :uid
 ORDER BY created DESC

-- name: backup_folders
SELECT *
  FROM backup.folders
 WHERE uid = :uid

-- name: backup_box
SELECT *
  FROM backup.box
 WHERE uid = :uid

-- name: folders_to_backup
SELECT *
  FROM backup.folders_to_backup
 WHERE uid = :uid

-- name: tabs_to_backup
SELECT *
  FROM backup.tabs_to_backup
 WHERE uid = :uid

-- name: archives
SELECT *
  FROM mail.archives
 WHERE uid = :uid

-- name: stickers_reply_later
SELECT *
  FROM mail.stickers_reply_later
 WHERE uid = :uid

