# coding: utf-8

import time

from pymdb.replication.parser import DML


class NoMoreMessagesInStream(Exception):
    pass


def is_dml_change(c):
    return isinstance(c, DML)


def get_current_wal_lsn(conn):
    '''return current write-ahead log write location'''
    # in Postge 10, xlog catalog (and all related functions) renamed to wal
    lsn_func = 'pg_current_wal_lsn'
    if conn.server_version < 100000:
        lsn_func = 'pg_current_xlog_location'
    cur = conn.cursor()
    cur.execute('SELECT %s()' % lsn_func)
    return cur.fetchone()[0]


def get_changes_with_timeout(replication_stream, timeout_seconds):
    for tm in [0.1] * 10 * timeout_seconds:
        for change in replication_stream.get_changes():
            if change is None:
                break
            yield change
        time.sleep(tm)
    raise NoMoreMessagesInStream("No more messages in a stream, and no more timeouts")
