# coding: utf-8

from mail.pypg.pypg.query_handler import (
    QueryHandler,
    FetchHeadExpectOneRowAs,
)
from mail.pypg.pypg.query_conf import load_from_package
from .queries import sync_fetch_as_dicts


class ShardQueries(QueryHandler):
    q = load_from_package(__package__, __file__)

    handlers = dict(
        doberman_jobs=(q.doberman_jobs, sync_fetch_as_dicts),
        last_record_from_dorberman_jobs_changelog=(
            q.last_record_from_dorberman_jobs_changelog,
            FetchHeadExpectOneRowAs(dict)),
    )
