# coding: utf-8

import random
from contextlib import closing

from mail.pypg.pypg.tools import (strip_q, PGLock, Diag)  # noqa


def generate_st_id(unit_id):
    return (str(random.randint(1, 100500)) + '.'
            + unit_id + '.' + 'E'
            + str(random.randint(1, 100500)) + ':'
            + str(random.randint(1, 100500)))


def find_free_uid(conn, max_in_memory_uid=0):
    with closing(conn.cursor()) as cur:
        cur.execute(
            strip_q('''
                SELECT greatest(coalesce(max(uid), 0), %(max_uid)s)
                  FROM mail.users
       FULL OUTER JOIN mail.change_log USING (uid)
            '''),
            vars=dict(max_uid=max_in_memory_uid),
        )
        conn.wait()
        max_uid = cur.fetchone()[0]
        return max_uid + 1


def mark_user_as_moved_from_here(conn, uid):
    cur = conn.cursor()
    cur.execute(
        '''UPDATE mail.users
              SET is_here=false,
                  purge_date=current_timestamp
            WHERE uid=%(uid)s
              AND is_here''',
        dict(uid=uid)
    )
    if conn.async_:
        conn.wait()
    assert cur.rowcount, 'No rows updated, probably user no longer here!'


def lock_contacts_user(conn, uid):
    cur = conn.cursor()
    cur.execute(
        '''SELECT is_here, is_deleted
             FROM contacts.users
            WHERE user_id = %(uid)s
              AND user_type = 'passport_user'::contacts.user_type
           FOR NO KEY UPDATE''',
        dict(uid=uid)
    )
    if conn.async_:
        conn.wait()
    row = cur.fetchone()
    if row:
        assert row[0], 'Contacts user is not here'


def mark_contacts_user_as_moved_from_here(conn, uid, is_deleted):
    cur = conn.cursor()
    cur.execute(
        '''UPDATE contacts.users
              SET is_here = false,
                  here_since = current_timestamp
            WHERE user_id = %(uid)s
              AND user_type = 'passport_user'::contacts.user_type
              AND is_here = true
              AND is_deleted = %(is_deleted)s''',
        dict(uid=uid, is_deleted=is_deleted)
    )
    if conn.async_:
        conn.wait()
