# coding: utf-8

from datetime import datetime

from mail.pypg.pypg.types.adapted import (
    _make_composite,
    BaseAdaptedComposite,
    BaseAdaptedList,
)

from mail.pypg.pypg.types.adapted import BaseAdapted  # noqa
from mail.pypg.pypg.types.adapted import SmallInt  # noqa
from mail.pypg.pypg.types.adapted import ListOfSmallInt  # noqa
from mail.pypg.pypg.types.adapted import ListOfMessageNumeric  # noqa

from .mixin import LabelCompareMixin

StoreCoordinates = _make_composite(
    'StoreCoordinates', [
        'fid', 'tid',
        'seen', 'deleted',
        'st_id', 'received_date',
        'size', 'attributes',
        'pop_uidl', 'tab'
    ],
    'code.store_coordinates_with_tab'
)

StoreDeletedCoordinates = _make_composite(
    'StoreDeletedCoordinates', [
        'st_id', 'received_date',
        'size', 'attributes'
    ],
    'code.store_deleted_coordinates'
)

MailishCoordinates = _make_composite(
    'MailishCoordinates', [
        'imap_id', 'imap_time'
    ],
    'code.mailish_coordinates'
)

MailishMoveCoords = _make_composite(
    'MailishMoveCoords', [
        'src_imap_id', 'dst_imap_id'
    ],
    'code.mailish_move_coords'
)


OwnerCoordinates = _make_composite(
    'OwnerCoordinates', [
        'uid', 'fid',
        'mid', 'tid',
        'revision',
    ],
    'code.owner_coordinates'
)


SyncCoordinates = _make_composite(
    'SyncCoordinates', [
        'seen', 'deleted',
        'st_id', 'received_date',
        'size', 'attributes',
    ],
    'code.sync_coordinates'
)


QuickSaveCoordinates = _make_composite(
    'QuickSaveCoordinates', [
        'st_id', 'received_date',
        'size', 'attributes',
        'pop_uidl'
    ],
    'code.quick_save_coordinates'
)


MailAttach = _make_composite(
    'MailAttach', [
        'hid', 'type', 'filename', 'size'
    ],
    'mail.attach'
)


StoreAttach = _make_composite(
    'StoreAttach', [
        'hid', 'type', 'filename', 'size'
    ],
    'code.store_attach'
)


SyncAttach = _make_composite(
    'SyncAttach', [
        'hid', 'type', 'filename', 'size',
    ],
    'code.sync_attach'
)


MailMimePart = _make_composite(
    'MailMimePart', [
        'hid', 'content_type', 'content_subtype', 'boundary', 'name',
        'charset', 'encoding', 'content_disposition', 'filename', 'cid',
        'offset_begin', 'offset_end'
    ],
    'mail.mime_part'
)


StoreMimePart = _make_composite(
    'StoreMimePart', [
        'hid', 'content_type', 'content_subtype', 'boundary', 'name',
        'charset', 'encoding', 'content_disposition', 'filename', 'cid',
        'offset_begin', 'offset_end'
    ],
    'code.store_mime_part'
)


SyncMimePart = _make_composite(
    'SyncMimePart', [
        'hid', 'content_type', 'content_subtype', 'boundary', 'name',
        'charset', 'encoding', 'content_disposition', 'filename', 'cid',
        'offset_begin', 'offset_end'
    ],
    'code.sync_mime_part'
)


StoreHeaders = _make_composite(
    'StoreHeaders', [
        'subject', 'firstline', 'hdr_date',
        'hdr_message_id',
        'extra_data'
    ],
    'code.store_headers'
)


SyncHeaders = _make_composite(
    'SyncHeaders', [
        'subject', 'firstline',
        'hdr_date', 'hdr_message_id',
    ],
    'code.sync_headers'
)


QuickSaveHeaders = _make_composite(
    'QuickSaveHeaders', [
        'firstline', 'hdr_date',
        'hdr_message_id'
    ],
    'code.quick_save_headers'
)


class ListOfMessageAttributes(BaseAdaptedList):
    __slots__ = ('seq',)
    pg_elem_type_name = 'mail.message_attributes'


class ListOfFixes(BaseAdaptedList):
    __slots__ = ('seq',)
    pg_elem_type_name = 'util.fix'


class MailLabelDef(LabelCompareMixin, BaseAdaptedComposite):
    __slots__ = (
        '_conn',
        'name', 'type', 'color', 'created'
    )
    defaults = {
        'color': None,
        'created': datetime.now,
    }

    pg_type_name = 'code.label_def'


MailRecipient = _make_composite(
    'MailRecipient', [
        'type', 'name', 'email'
    ],
    'mail.recipient'
)


StoreRecipient = _make_composite(
    'StoreRecipient', [
        'type', 'name', 'email'
    ],
    'code.store_recipient'
)


class SyncRecipient(StoreRecipient):
    pg_type_name = 'code.sync_recipient'


StoreThreading = _make_composite(
    'StoreThreading', [
        'rule',
        'references_hashes', 'in_reply_to_hash',
        'hash_value', 'hash_namespace', 'hash_uniq_key',
        'sort_options'
    ],
    'code.store_threading'
)


SyncThreading = _make_composite(
    'SyncThreading', [
        'references_hashes', 'in_reply_to_hash',
    ],
    'code.sync_threading'
)


Pop3State = _make_composite(
    'Pop3State', [
        'initialized', 'enabled'
    ],
    'mail.pop3state'
)


MailishFolderInfo = _make_composite(
    'MailishFolderInfo', [
        'path', 'uidvalidity'
    ],
    'code.mailish_folder_info'
)


NewContact = _make_composite(
    'NewContact', [
        'list_id', 'format', 'vcard', 'uri'
    ],
    'code.new_contact'
)


UpdatedContact = _make_composite(
    'UpdatedContact', [
        'contact_id', 'list_id', 'format', 'vcard', 'uri'
    ],
    'code.updated_contact'
)


NewContactsEmail = _make_composite(
    'NewContactsEmail', [
        'contact_id', 'email', 'type', 'label'
    ],
    'code.new_contacts_email'
)


UpdatedContactsEmail = _make_composite(
    'UpdatedContactsEmail', [
        'email_id', 'contact_id', 'email', 'type', 'label'
    ],
    'code.updated_contacts_email'
)


BackupMidsMapping = _make_composite(
    'BackupMidsMapping', [
        'original', 'renewed'
    ],
    'backup.mid_to_mid'
)


BackupFidsMapping = _make_composite(
    'BackupFidsMapping', [
        'original', 'renewed'
    ],
    'backup.fid_to_fid'
)


BackupFidsMapping = _make_composite(
    'BackupFidsMapping', [
        'original', 'renewed'
    ],
    'backup.fid_to_fid'
)


BackupSettings = _make_composite(
    'BackupSettings', [
        'fids', 'tabs'
    ],
    'backup.settings'
)
