# coding: utf-8

import re

from psycopg2 import InterfaceError
import psycopg2.extensions as PGE

from mail.pypg.pypg.connect import global_register_unicode

from .selected import ThreadLabel
from .adapted import Pop3State, BackupFidsMapping

# http://initd.org/psycopg/docs/advanced.html#type-casting-of-sql-types-into-python-objects


def cast_thread_label(value, cur):
    if value is None:
        return None
    m = re.match(r"\(([^)]+),([^)]+)\)", value)
    if m is not None:
        return ThreadLabel(int(m.group(1)), int(m.group(2)))
    else:
        raise InterfaceError("bad ThreadLabel representation: %r" % value)


def cast_pop3_state(value, cur):
    if value is None:
        return None
    m = re.match(r"\(([^)]+),([^)]+)\)", value)
    if m is not None:
        return Pop3State(initialized=bool(m.group(1) == 't'), enabled=bool(m.group(2) == 't'))
    else:
        raise InterfaceError("bad Pop3State representation: %r" % value)


def cast_backup_fids_mapping(value, cur):
    if value is None:
        return None
    m = re.match(r"\(([^)]+),([^)]+)\)", value)
    if m is not None:
        return BackupFidsMapping(original=int(m.group(1)), renewed=int(m.group(2)))
    else:
        raise InterfaceError("bad BackupFidsMapping representation: %r" % value)


def register_type(conn, db_type, cast_type, caster=lambda v, _: v):
    cur = conn.cursor()
    cur.execute("SELECT NULL::{db_type}, NULL::{db_type}[]".format(db_type=db_type))
    conn.wait()
    oid = cur.description[0][1]
    array_oid = cur.description[1][1]

    typ = PGE.new_type((oid,), cast_type, caster)
    PGE.register_type(typ, conn)
    PGE.register_type(PGE.new_array_type((array_oid,), "{}[]".format(cast_type), typ), conn)


def register_types(conn):
    register_type(conn, 'mail.thread_label', 'THREAD_LABEL', cast_thread_label)
    register_type(conn, 'mail.pop3state', 'POP3_STATE', cast_pop3_state)
    register_type(conn, 'backup.fid_to_fid', 'BACKUP_FIDS_MAPPING', cast_backup_fids_mapping)
    register_type(conn, 'mail.tab_types', 'MAIL_TAB_TYPES')
    global_register_unicode()
