# coding: utf-8

from abc import ABCMeta, abstractmethod
from collections import namedtuple


class CmpableMixin(object):
    __metaclass__ = ABCMeta

    @classmethod
    @abstractmethod
    def cmpable_keys(cls):
        pass

    def cmpable(self):
        CmpableTuple = namedtuple(
            self.__class__.__name__ + '_CmpableTuple',
            self.cmpable_keys()
        )
        values = (getattr(self, n) for n in self.cmpable_keys())
        values = (
            v.cmpable() if isinstance(v, CmpableMixin) else v
            for v in values)
        return CmpableTuple(*list(values))


class LabelCompareMixin(CmpableMixin):
    __metaclass__ = ABCMeta

    @staticmethod
    def cmpable_keys():
        return ('name', 'type',)

    def __eq__(self, other):
        return self.name == other.name and self.type == other.type

    def __hash__(self):
        return hash((self.name, self.type))
