# coding: utf-8

"""
vegetarian cause eat fruits and vegetables
"""

import random
import datetime
import mimetypes
import json
from itertools import cycle
from collections import Counter
from .operations import (
    Init,
    StoreMessage,
    CreateFolder,
    ResolveLabels,
    InitExistingFolderAsMailish,
    SaveMailishAccount,
    AddWindat,
    CreateSettings,
    CreateContactsUser,
    CreateContactsList,
    CreateContactsTag,
    CreateContacts,
    CreateContactsEmails,
    TagContacts,
    TagContactsEmails,
    ShareContactsList,
)
from .types import MailishFolderInfo, MailishCoordinates, NewContact, NewContactsEmail, ContactsUserType
from . import types as TYP
from .queries import Queries

FRUITS = [
    'apple',
    'banana',
    'pear',
    'cherry',
    'durian'
    'plum',
    'orange',
    'peach',
    'grapefruit',
    'grape'
]

VEGETABLES = [
    'potato',
    'carrot',
    'onion',
    'tomato',
    'cucumber',
    'lettuce',
    'radish',
    'pumpkin',
    'pepper'
]

ACTIONS = [
    'eat',
    'boil',
    'trash',
    'grill',
    'burn'
]

TASTES = [
    'sweet',
    'sour',
    'salty',
    'bitter',
    'pungent',
    'astringent',
]

SAMPLE_STIDS = [
    "182.66466005.8916062197912345678901234567",
    "102.66466005.241046198820547232969001058",
    "102.66466005.134090406637961488505874094",
    "102.66466005.833108344210793547739411603",
    "182.66466005.789123456987654123432999991",
    "102.66466005.613194258946009445946806791",
    "102.66466005.283888740235854586241366303",
    "182.66466005.7864012837108371312345678",
    "102.66466005.160583550285352835677980501",
    "102.66466005.157526963565013225811429732",
    "102.66466005.776572722362711757375188712",
    "102.66466005.843050852019811185954526976",
    "102.66466005.581223971584387788428107214",
    "102.66466005.12345678901223323456789012345678",
    "102.66466005.974595641548829263805250943",
    "102.66466005.856799731918248093078980991",
    "102.66466005.845964826770038432122364019",
    "102.66466005.845964826770038432122364020",
    "102.66466005.845964826770038432122364021",
    "102.66466005.845964826770038432122364022",
    "102.66466005.845964826770038432122364023",
    "102.66466005.845964826770038432122364024",
    "102.66466005.845964826770038432122364025",
    "102.66466005.845964826770038432122364026",
    "102.66466005.845964826770038432122364027",
    "102.66466005.845964826770038432122364028",
    "102.66466005.845964826770038432122364029",
    "102.66466005.845964826770038432122364030",
    "102.66466005.845964826770038432122364031",
    "102.66466005.845964826770038432122364032",
    "102.66466005.845964826770038432122364033",
]

SAMPLE_WINDAT_STIDS = [
    "100.windat.E100:241046198820547232969001058",
    "101.windat.E101:134090406637961488505874094",
    "102.windat.E102:833108344210793547739411603",
    "103.windat.E103:789123456987654123432999991",
    "104.windat.E104:613194258946009445946806791",
    "105.windat.E105:283888740235854586241366303",
    "106.windat.E106:7864012837108371312345678",
    "107.windat.E107:160583550285352835677980501",
    "108.windat.E108:776572722362711757375188712",
    "109.windat.E109:157526963565013225811429732",
    "110.windat.E110:843050852019811185954526976",
    "111.windat.E111:581223971584387788428107214",
    "112.windat.E112:12345678901223323456789012345678",
    "113.windat.E113:974595641548829263805250943",
    "114.windat.E114:856799731918248093078980991",
    "115.windat.E115:845964826770038432122364019",
]

MAILISH_AUTH_DATA = {
    'email': 'user@mail.site',
    'imap_login': 'user@mail.site',
    'imap_credentials': 'mailishpassword',
    'imap_server': 'imap.mailish.site',
    'imap_port': 993,
    'imap_ssl': True,
    'smtp_login': 'user@mail.site',
    'smtp_credentials': 'mailishpassword',
    'smtp_server': 'smtp.mailish.site',
    'smtp_port': 25,
    'smtp_ssl': True,
    'token_id': '1982312398128912893210',
    'auth_type': 'password',
    'uuid': '123-wqe-123d-123',
    'oauth_app': 'mailru-o2',
    'last_sync': None,
    'auth_data': 'mailishpassword'
}


SETTINGS = {
    'color': ['green', 'red', 'black'],
    'size': ['small', 'normal', 'incredible'],
    'taste': ['tasty', 'inert', 'disgusting'],
    'benefits': ['no', 'damage', 'toxic'],
}


def get_enum_values(conn, type_name):
    cur = conn.cursor()
    cur.execute(
        "SELECT * FROM unnest(enum_range(null::%s)) t" % type_name
    )
    conn.wait()
    res = [r[0] for r in cur.fetchall()]
    return res


def get_some_mimetype():
    return random.choice(random.choice(list(mimetypes.common_types.items())))


def make_mime_part(action_target, hid, TypeMimePart):
    file_ext, file_type = random.choice(list(mimetypes.common_types.items()))
    content_type, content_subtype = file_type.split('/')
    return TypeMimePart(
        hid=hid,
        content_type=content_type,
        content_subtype=content_subtype,
        boundary='--boundary' + hid,
        name=action_target + hid,
        charset='charset' + hid,
        encoding='encoding' + hid,
        content_disposition='content_disposition' + hid,
        filename=action_target + hid + file_ext,
        cid='cid' + hid,
        offset_begin=random.randint(100, 500),
        offset_end=random.randint(600, 1000)
    )


def make_attach(action_target, hid):
    file_ext, file_type = random.choice(list(mimetypes.common_types.items()))
    return TYP.StoreAttach(
        hid=hid,
        type=file_type,
        filename=action_target + file_ext,
        size=random.randint(100, 500),
    )


def make_actions(limit):
    action_target = FRUITS + VEGETABLES
    for _ in range(limit):
        yield random.choice(ACTIONS), random.choice(action_target)


def messages_in_folder_generator(conn, uid, folder, limit, stids, is_mailish=False):
    q = Queries(conn, uid)
    recipients_types = get_enum_values(conn, 'mail.recipient_type')
    recipients_types.remove('reply-to-all')
    recipients_types.remove('sender')

    stids_iter = iter(stids)

    lids = [l.lid for l in q.labels()]
    for action_num, (action, action_target) in enumerate(
            make_actions(limit)):
        try:
            our_stid = next(stids_iter)
        except StopIteration:
            raise RuntimeError(
                'Not enough stids for %r folder fill' % folder
            )
        mail_date = \
            datetime.datetime.now() - datetime.timedelta(days=action_num)
        subject = '{0} a {1} in subject'.format(action, action_target)
        attaches = []
        if not action_num % 3:
            attaches.append(
                make_attach(action_target, '3.%d' % action_num)
            )
        if not action_num % 5:
            attaches.append(
                make_attach(action_target, '5.%d' % action_num)
            )
        size = sum([a.size for a in attaches]) + random.randint(42, 100500)

        mime = []
        if not action_num % 2:
            mime.append(make_mime_part(action_target, '1.2.%d' % action_num, TYP.StoreMimePart))
        if not action_num % 3:
            mime.append(make_mime_part(action_target, '1.3.%d' % action_num, TYP.StoreMimePart))
        if mime == []:
            mime = None

        mailish_coords = None
        if is_mailish:
            mailish_coords = MailishCoordinates(
                imap_id=action_num * 10 + random.randint(0, 9),
                imap_time=mail_date
            )

        yield dict(
            coords=TYP.StoreCoordinates(
                fid=folder.fid,
                tid=None if action_num % 3 else (action_num % 5 + 1),
                seen=bool(action_num % 2),
                deleted=not bool(action_num % 7),
                st_id=our_stid,
                received_date=mail_date,
                size=size,
                attributes=[],
                pop_uidl='',
                ora_mid=None,
                tab=None,
            ),
            headers=TYP.StoreHeaders(
                subject=subject,
                firstline='{0} a {1} in firstline'.format(
                    action, action_target),
                hdr_date=mail_date,
                hdr_message_id='{0}@{1}'.format(action_num, folder.fid),
                extra_data=None
            ),
            recipients=[
                TYP.StoreRecipient(
                    name=random.choice(FRUITS),
                    email=random.choice(VEGETABLES) + '@ya.ru',
                    type=rt
                ) for rt in recipients_types
            ],
            attaches=attaches,
            mime=mime,
            lids=random.sample(lids, action_num % 3),
            threads_meta=TYP.StoreThreading(
                rule='hash',
                references_hashes=[],
                in_reply_to_hash=None,
                hash_value=42 if action_num % 3 else (action_num % 5 + 1),
                hash_namespace='subject',
                hash_uniq_key=0,
                sort_options='',
            ),
            mailish_coords=mailish_coords
        )


def fill_messages_in_folder(conn, uid, folder, limit, stids, is_mailish=False):
    mids = []
    for store_args in messages_in_folder_generator(
            conn, uid, folder, limit, stids, is_mailish):
        store_op = StoreMessage(conn, uid)(**store_args)
        store_op.commit()
        mids.extend([res.mid for res in store_op.result])
    return mids


def create_labels_for_user(conn, uid):
    label_types = [
        l for l in get_enum_values(conn, 'mail.labels_types')
        if l != 'type']

    now = datetime.datetime.now()
    ResolveLabels(conn, uid)(
        [TYP.MailLabelDef(
            name=l[0],
            type=l[1],
            created=now - datetime.timedelta(days=i)
        ) for (i, l) in enumerate(zip(FRUITS, label_types))
        ]).commit()


def create_folders_for_user(conn, uid, is_mailish=False):
    for folder_name in random.sample(VEGETABLES, 3):
        create_op = CreateFolder(conn, uid)
        create_op(folder_name).commit()

    folders = Queries(conn, uid).folders()
    if is_mailish:
        for folder in folders:
            init_op = InitExistingFolderAsMailish(conn, uid)
            mailish_info = MailishFolderInfo(path=folder.name, uidvalidity=random.randint(1000, 10000))
            init_op(folder.fid, mailish_info).commit()
    return folders


def create_mailish_account_for_user(conn, uid):
    save_op = SaveMailishAccount(conn, uid)
    save_op(MAILISH_AUTH_DATA).commit()


def windat_stids_generator(limit):
    for _ in range(limit):
        yield random.choice(SAMPLE_WINDAT_STIDS)


def make_windat(conn, uid, mid):
    if not mid:
        return
    limit = random.randint(0, 2)
    count = 0
    for (action_num, (action, action_target)), windat_stids in zip(
            enumerate(make_actions(limit)), windat_stids_generator(limit)):
        hid = '1.%d' % action_num
        AddWindat(conn, uid)(mid, windat_stids, hid, make_mime_part(action_target, hid, TYP.MailMimePart)).commit()
        count += 1
    return count


def make_settings(conn, uid):
    settings = dict()
    for key, val in SETTINGS.items():
        settings[key] = random.choice(val)

    CreateSettings(conn, uid)(
        json.dumps(dict(single_settings=settings))
    ).commit()


def fill_data(conn, uid, limit_per_folder=36, stids=None, is_mailish=False, context=None):
    stids = stids or SAMPLE_STIDS
    Init(conn, uid)().commit()

    if is_mailish:
        create_mailish_account_for_user(conn, uid)

    create_labels_for_user(conn, uid)

    stids_iter = cycle(stids)
    mids = []
    counter = Counter()
    for folder in create_folders_for_user(conn, uid, is_mailish=is_mailish):
        new_mids = fill_messages_in_folder(
            conn=conn,
            uid=uid,
            folder=folder,
            limit=limit_per_folder,
            stids=stids_iter,
            is_mailish=is_mailish
        )
        mids += new_mids
        counter[folder.fid] += len(new_mids)

    counter['windat_folder'] += make_windat(conn, uid, random.choice(mids))
    make_settings(conn, uid)
    make_contacts(conn, uid, ContactsUserType.passport_user)
    if context:
        context.messages_count = counter


def make_contacts(conn, uid, user_type):
    CreateContactsUser(conn, uid, user_type)(x_request_id='tests').commit()
    default_list_id = Queries(conn, uid).passport_user_default_contacts_list_id()[0]
    tag_id = CreateContactsTag(conn, uid, user_type)(
        tag_name=random.choice(TASTES),
        tag_type='user',
        x_request_id='tests',
    ).commit().result[0]['tag_id']
    contact_ids = CreateContacts(conn, uid, user_type)(
        new_contacts=[
            NewContact(
                list_id=default_list_id,
                format='vcard_v1',
                vcard=make_vcard(random.choice(FRUITS), random.choice(VEGETABLES)),
                uri=None,
            ) for _ in range(10)
        ],
        x_request_id='tests',
    ).commit().result[0]['contact_ids']
    tagged_contact_ids = contact_ids[3:8]
    TagContacts(conn, uid, user_type)(
        tag_id=tag_id,
        contact_ids=tagged_contact_ids,
        x_request_id='tests',
    ).commit()
    all_email_ids = list()
    all_emails = set()
    for n, contact_id in enumerate(contact_ids[:5]):
        emails = list()
        while len(emails) <= n:
            email = '%s-%s@ya.ru' % (random.choice(VEGETABLES), random.choice(FRUITS))
            if email not in all_emails:
                all_emails.add(email)
                emails.append(email)
        email_ids = CreateContactsEmails(conn, uid, user_type)(
            new_emails=[
                NewContactsEmail(
                    contact_id=contact_id,
                    email=v,
                    type=[random.choice(TASTES) for _ in range(n)],
                    label=random.choice(ACTIONS),
                ) for v in emails
            ],
            x_request_id='tests',
        ).commit().result[0]['email_ids']
        if contact_id in tagged_contact_ids:
            all_email_ids += email_ids
    TagContactsEmails(conn, uid, user_type)(
        tag_id=tag_id,
        email_ids=[v for n, v in enumerate(all_email_ids) if n % 2 == 0],
        x_request_id='tests',
    )
    shared_list_id = CreateContactsList(conn, uid, user_type)(
        list_name='shared',
        list_type='user',
        x_request_id='tests',
    ).commit().result[0]['list_id']
    CreateContacts(conn, uid, user_type)(
        new_contacts=[
            NewContact(
                list_id=shared_list_id,
                format='vcard_v1',
                vcard=make_vcard(random.choice(FRUITS), random.choice(VEGETABLES)),
                uri=None,
            ) for _ in range(10)
        ],
        x_request_id='tests',
    ).commit()
    ShareContactsList(conn, uid, user_type)(
        list_id=shared_list_id,
        client_user_id=100500,
        client_user_type=ContactsUserType.passport_user,
        x_request_id='tests',
    ).commit()


def make_vcard(first_name, last_name):
    return json.dumps(dict(names=[dict(first=first_name, last=last_name)]))
