from setuptools import setup, find_packages


# /usr/lib/python2.6/site-packages/setuptools/dist.py:294: UserWarning: The version specified ('None-None') is an invalid version, this may not work as expected with newer versions of setuptools, pip, and PyPI. Please see PEP 440 for more details.
#  "details." % self.metadata.version
def get_version_from_env():
    import os
    version = os.environ.get('SPEC_VERSION')
    release = os.environ.get('SPEC_RELEASE')
    if version or release:
        return '{version}-{release}'.format(**locals())
    return '0.0.dev0'


YAQT_AND_TESTS = (
    'yaqt*',
    'tests*',
    'integration*',
)

setup(
    name="yamail_pymdb",
    version=get_version_from_env(),
    packages=find_packages(exclude=YAQT_AND_TESTS),
    description="Oracle to PostgreSQL migration",
    long_description="Transfer yandex mail metadata from Oracle to PostgreSQL",
    license="Yandex license",
    url="https://github.yandex-team.ru/mail/mdb/",
    author='Webmail Woof',
    author_email='webmail-team@yandex-team.ru',
    package_data={
        'pymdb': [
            '*.sql',
            'replication/*.ebnf'
        ],
    },
    install_requires=[
        'yamail-pypg',
        'colorlog',
        'raven',
        'python-daemon',
        'werkzeug',
        'gunicorn',
        'enum34',
        'pyaml',
        'tatsu',
    ],
    tests_require=[
        'tzlocal',
        'pytest',
        'pytest_cov',
        'mock',
        'behave',
    ],
)
