# coding: utf-8
from __future__ import print_function

from contextlib import closing
from argparse import ArgumentParser
import psycopg2
import os


def find_users_from_grants(grants_dir):
    users = {}
    for fname in os.listdir(grants_dir):
        if fname.endswith('.sql'):
            user = fname[:fname.rfind('.sql')]
            users[user] = user + 'pass'
    return users


def main():
    default_grants_dir = os.path.join(
        os.path.dirname(__file__),
        os.path.pardir,
        'grants')
    parser = ArgumentParser()
    parser.add_argument(
        'dsn',
        help='dba connection string'
    )
    parser.add_argument(
        '--grants-dir',
        metavar='DIR',
        help='dir with grants (default:%s)' % default_grants_dir,
        default=default_grants_dir,
    )
    args = parser.parse_args()
    users = find_users_from_grants(args.grants_dir)

    with closing(psycopg2.connect(args.dsn)) as conn:
        cur = conn.cursor()
        cur.execute("""SELECT un
                         FROM unnest(%s) AS un
                        WHERE NOT EXISTS (
                            SELECT 1
                              FROM pg_user p
                             WHERE p.usename = un
                            )""", (users.keys(),))

        new_users = [r[0] for r in cur]
        for new_user in new_users:
            cur.execute(
                "CREATE USER {0} PASSWORD %s".format(new_user),
                (users[new_user],)
            )

        conn.commit()


if __name__ == '__main__':
    main()
