DROP SCHEMA IF EXISTS settings CASCADE;
CREATE SCHEMA settings;

CREATE TABLE settings.settings (
    uid bigint NOT NULL,
    value jsonb,
    CONSTRAINT pk_settings PRIMARY KEY (uid),
    CONSTRAINT fk_settings_uid_users FOREIGN KEY (uid) REFERENCES mail.users ON DELETE CASCADE
);

CREATE TYPE settings.modify_type AS ENUM (
    'update',
    'init',
    'update_for_all',
    'update_by_uids'
);

CREATE TABLE settings.bulk_modification (
    id smallserial UNIQUE NOT NULL,
    name text NOT NULL DEFAULT '',
    create_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    type settings.modify_type,
    settings json,
    CONSTRAINT only_one_row CHECK (id = 1)
);

CREATE TABLE settings.users_for_init (
    uid bigint NOT NULL,
    is_modified boolean DEFAULT FALSE,
    CONSTRAINT pk_users_for_init PRIMARY KEY (uid),
    CONSTRAINT fk_users_for_init_uid_users FOREIGN KEY (uid) REFERENCES mail.users ON DELETE CASCADE
);

CREATE INDEX users_is_inited ON settings.users_for_init (uid) WHERE NOT is_modified;

CREATE TABLE settings.users_for_update (
    uid bigint NOT NULL,
    is_modified boolean DEFAULT FALSE,
    CONSTRAINT pk_users_for_update PRIMARY KEY (uid)
);

CREATE INDEX users_is_updated ON settings.users_for_update (uid) WHERE NOT is_modified;
