PY3TEST()

OWNER(
    g:mail
)

SIZE(MEDIUM)

REQUIREMENTS(
    cpu:4
    ram:16
    disk_usage:10
    ram_disk:4
)

TEST_SRCS(
    steps/__init__.py

    steps/accidents.py
    steps/add_windat.py
    steps/attach_counters.py
    steps/backup.py
    steps/blacklist.py
    steps/changelog.py
    steps/collectors.py
    steps/combos.py
    steps/contacts.py
    steps/copy_messages.py
    steps/data_version.py
    steps/debug.py
    steps/delete.py
    steps/delete_user.py
    steps/doberman_jobs.py
    steps/filters.py
    steps/folder_archivation_rules.py
    steps/folder.py
    steps/fresh.py
    steps/helpers.py
    steps/imap.py
    steps/imap_unsubscribed.py
    steps/labels.py
    steps/lists.py
    steps/mailish.py
    steps/message.py
    steps/migrations.py
    steps/move.py
    steps/new_user.py
    steps/pop3.py
    steps/purge_deleted_messages.py
    steps/purge_user.py
    steps/replication.py
    steps/serials.py
    steps/sessions.py
    steps/settings.py
    steps/shared_folder_change_queue.py
    steps/shared_folders.py
    steps/shared_folder_subscriptions.py
    steps/stickers.py
    steps/storage_delete_queue.py
    steps/store.py
    steps/sync_delete.py
    steps/sync_join_threads.py
    steps/sync_message.py
    steps/sync_update.py
    steps/tables.py
    steps/tabs.py
    steps/unsubscribe_tasks.py
    steps/update.py
    steps/update_archive_state.py
    steps/update_user_state.py
    steps/utils.py

    conftest.py
    step_types_defs.py
    test_features.py
)

DATA(
    arcadia/mail/pg/mdb/tests/pytest_bdd/features
)

RESOURCE_FILES(
    mail/pg/mdb/tests/pytest_bdd/steps/accidents.sql
    mail/pg/mdb/tests/pytest_bdd/steps/backup.sql
    mail/pg/mdb/tests/pytest_bdd/steps/delete_user.sql
    mail/pg/mdb/tests/pytest_bdd/steps/doberman_jobs.sql
    mail/pg/mdb/tests/pytest_bdd/steps/shared_folder_subscriptions.sql
    mail/pg/mdb/tests/pytest_bdd/steps/storage_delete_queue.sql
    mail/pg/mdb/tests/pytest_bdd/steps/tabs.sql
    mail/pg/mdb/tests/pytest_bdd/steps/update_archive_state.sql
    mail/pg/mdb/tests/pytest_bdd/steps/update_user_state.sql
    mail/pg/mdb/tests/pytest_bdd/steps/unsubscribe_tasks.sql

    mail/pg/mdb/tests/override/impl/20_get_blacklist_limit.sql
    mail/pg/mdb/tests/override/impl/20_get_chain_size.sql
    mail/pg/mdb/tests/override/impl/20_purge_mids_chunk_size.sql
    mail/pg/mdb/tests/override/util/10_search_chunk_size.sql

    mail/pg/mdb/tests/schemas/arguments/move_messages.json
    mail/pg/mdb/tests/schemas/arguments/move_messages_to_tab.json
    mail/pg/mdb/tests/schemas/arguments/sync_join_threads.json
    mail/pg/mdb/tests/schemas/arguments/update_messages.json
    mail/pg/mdb/tests/schemas/changed/delete_messages.json
    mail/pg/mdb/tests/schemas/changed/move_messages.json
    mail/pg/mdb/tests/schemas/changed/quick_save_message.json
    mail/pg/mdb/tests/schemas/changed/store_deleted_message.json
    mail/pg/mdb/tests/schemas/changed/store_message.json
    mail/pg/mdb/tests/schemas/changed/sync_delete_messages.json
    mail/pg/mdb/tests/schemas/changed/sync_join_threads.json
    mail/pg/mdb/tests/schemas/changed/sync_store_messages.json
    mail/pg/mdb/tests/schemas/changed/sync_update_messages.json
    mail/pg/mdb/tests/schemas/changed/update_messages.json
)



IF (SANITIZER_TYPE)
    # XXX: Sanitizer usage for SQL testing is useless
    TAG(ya:not_autocheck)
ENDIF()

PEERDIR(
    contrib/python/parse
    contrib/python/parse-type
    contrib/python/jsonschema

    contrib/python/PyHamcrest
    contrib/python/pytest-bdd
    contrib/python/retry
    library/python/resource
    mail/devpack/lib
    mail/devpack/tests/helpers
    mail/docker_tests
    mail/pypg
    mail/pg/mdb/tests/tools
)

END()
