CREATE OR REPLACE FUNCTION util.make_chunks(
    i_arr        bigint[],
    i_chunk_size bigint
) RETURNS SETOF bigint[] AS $$
SELECT array_agg(v_item)
  FROM (
    SELECT v_item,
           row_number() OVER (ORDER BY v_item) AS rn
      FROM unnest(i_arr) AS v_item) add_rn
 GROUP BY ceil(rn/i_chunk_size::real);
$$ LANGUAGE SQL IMMUTABLE;
