CREATE OR REPLACE FUNCTION util.delete_folders_subtree(
    i_uid      code.uid,
    i_root_fid code.fid
) RETURNS void AS $$
DECLARE
    v_mids bigint[];
    v_fid  int;
BEGIN
    v_mids := ARRAY(
        SELECT mid
          FROM mail.box
         WHERE uid = i_uid
           AND fid IN (
            SELECT fid
              FROM code.get_folders_tree(i_uid, i_root_fid))
    );
    IF cardinality(v_mids) > 0 THEN
        PERFORM code.move_messages(
            i_uid     => i_uid,
            i_mids    => v_mids,
            i_dst_fid => code.get_folder_fid(i_uid, 'inbox')
        );
        PERFORM code.move_messages_to_tab(
            i_uid     => i_uid,
            i_mids    => v_mids,
            i_dst_tab => 'relevant'::mail.tab_types
        );
    END IF;
    FOR v_fid IN (
        SELECT fid
          FROM code.get_folders_tree(
            i_uid, i_root_fid)
         ORDER BY level DESC)
    LOOP
        PERFORM code.delete_folder(
            i_uid  => i_uid,
            i_fid  => v_fid
        );
    END LOOP;
END;
$$ LANGUAGE plpgsql;
