CREATE OR REPLACE FUNCTION util.change_label_type(
    i_uid        code.uid,
    i_label      mail.labels,
    i_new_type   mail.labels_types
) RETURNS void AS $$
DECLARE
    v_new_label code.label_info;
    v_mids      bigint[];
BEGIN
    SELECT *
      INTO v_new_label
      FROM code.resolve_labels(
        i_uid,
        ARRAY[(
            i_label.name,
            i_new_type,
            i_label.color,
            i_label.created
        )::code.label_def]
    ) AS l;

    FOR v_mids IN (
        SELECT mids_chunk
          FROM util.make_chunks(
            impl.find_mids_by_lid(
                i_uid, i_label.lid),
            util.search_chunk_size()) AS mids_chunk
    ) LOOP
        PERFORM code.update_messages(
            i_uid       := i_uid,
            i_mids      := v_mids,
            set_seen    := NULL,
            set_recent  := NULL,
            set_deleted := NULL,
            i_lids_add  := ARRAY[v_new_label.lid],
            i_lids_del  := ARRAY[i_label.lid]
        );
    END LOOP;
    PERFORM code.delete_label(
        i_uid := i_uid,
        i_lid := i_label.lid
    );
END;
$$ LANGUAGE plpgsql;