CREATE OR REPLACE FUNCTION util.drag_messages(
    i_uid        code.uid,
    i_mids       code.mids,
    i_source_fid code.fid,
    i_dest_fid   code.fid
) RETURNS void AS $$
BEGIN
    IF i_source_fid IS NOT DISTINCT FROM i_dest_fid THEN
        RAISE EXCEPTION
            'Drag messages require different source_fid % and dest_fid %',
                i_source_fid, i_dest_fid;
    END IF;

    PERFORM code.move_messages(
        i_uid,
        i_mids,
        i_dest_fid
    );
    PERFORM code.move_messages(
        i_uid,
        i_mids,
        i_source_fid
    );
END;
$$ LANGUAGE plpgsql;