CREATE OR REPLACE FUNCTION util.fill_counters(
    i_uid        bigint
) RETURNS void AS $$
    UPDATE mail.folders
       SET message_count = 0,
           message_seen = 0,
           message_recent = 0,
           attach_count = 0,
           attach_size = 0,
           message_size = 0,
           first_unseen = 0,
           first_unseen_id = NULL
     WHERE uid = i_uid;

    UPDATE mail.folders f
       SET message_count = r.message_count,
           message_seen = r.message_seen,
           attach_count = r.attach_count,
           message_recent = r.message_recent,
           attach_size = r.attach_size,
           message_size = r.message_size,
           revision = greatest(r.max_revision, revision),
           next_imap_id = greatest(r.max_imap_id + 1, next_imap_id)
      FROM (
        SELECT fid,
               count(*) as message_count,
               sum(seen::integer) as message_seen,
               sum(size) as message_size,
               sum(recent::integer) as message_recent,
               sum(coalesce(array_length(attaches, 1), 0)) as attach_count,
               sum(code.get_attaches_size(attaches)) as attach_size,
               max(imap_id) as max_imap_id,
               max(revision) as max_revision
          FROM mail.box mb
          JOIN mail.messages mm
            ON (mb.uid = mm.uid AND mb.mid = mm.mid)
         WHERE mb.uid = i_uid
         GROUP BY fid) AS r
      WHERE f.uid = i_uid
        AND f.fid = r.fid;

    UPDATE mail.folders f
       SET first_unseen = ff.first_unseen,
           first_unseen_id = ff.first_unseen_id
      FROM (
        SELECT fid, ff.*
          FROM mail.folders fi,
               impl.find_first_unseen(i_uid, fi.fid) AS ff
         WHERE uid = i_uid) ff
     WHERE f.uid = i_uid
       AND f.fid = ff.fid;

    UPDATE mail.labels
       SET message_count = 0,
           message_seen = CASE WHEN message_seen is NULL THEN NULL ELSE 0 END
     WHERE uid = i_uid;

    UPDATE mail.labels ld
       SET message_count = r.message_count,
           message_seen = CASE WHEN message_seen is NULL THEN NULL ELSE real_message_seen END
      FROM (
        SELECT lid,
               count(*) as message_count,
               sum(seen::integer) AS real_message_seen
          FROM (
            SELECT seen, unnest(lids) AS lid
              FROM mail.box
             WHERE uid = i_uid
               AND tid IS NOT NULL) m
         GROUP BY lid) as r
    WHERE ld.uid = i_uid
      AND ld.lid = r.lid;

    INSERT INTO mail.threads
        (uid, tid, revision,
        newest_date, newest_mid,
        message_count, message_seen,
        attach_count, attach_size,
        labels)
    SELECT i_uid, bt.tid, revision,
           newest_date, newest_mid,
           message_count, message_unseen,
           attach_count, attach_size,
           labels
      FROM (
        SELECT tid, max(revision) revision,
               max(newest_date) newest_date,
               max(newest_mid) newest_mid,
               count(1) message_count,
               sum(seen) message_unseen,
               sum((ai).attach_count::integer) as attach_count,
               sum((ai).attach_size) as attach_size
          FROM (
        SELECT tid, revision,
               seen::integer seen,
               last_value(received_date) over mids_in_thread as newest_date,
               last_value(mb.mid) over mids_in_thread as newest_mid,
               (SELECT code.get_attaches_info(attaches)
                  FROM mail.messages m
                 WHERE m.uid = mb.uid
                   AND m.mid = mb.mid) AS ai
          FROM mail.box mb
         WHERE mb.uid = i_uid
           AND tid IS NOT NULL
        WINDOW mids_in_thread AS (
          partition by tid order by received_date
          rows between unbounded preceding and unbounded following)) m
         GROUP by tid) bt
       LEFT JOIN
       (SELECT tid,
               array_agg((lid, message_count)::mail.thread_label) AS labels
          FROM (
            SELECT tid, lid, count(*) as message_count
              FROM mail.box m, unnest(m.lids) AS lid
             WHERE uid = i_uid
               AND tid IS NOT NULL
             GROUP BY tid, lid) ll
         GROUP BY tid) tl
         ON (bt.tid = tl.tid);

    UPDATE mail.tabs t
       SET message_count = r.message_count,
           message_seen = r.message_seen,
           message_size = r.message_size,
           attach_count = r.attach_count,
           attach_size = r.attach_size,
           revision = greatest(r.max_revision, revision)
      FROM (
        SELECT tab,
               count(*) as message_count,
               sum(seen::integer) as message_seen,
               sum(size) as message_size,
               sum(coalesce(array_length(attaches, 1), 0)) as attach_count,
               sum(code.get_attaches_size(attaches)) as attach_size,
               max(revision) as max_revision
          FROM mail.box mb
          JOIN mail.messages mm
            ON (mb.uid = mm.uid AND mb.mid = mm.mid)
         WHERE mb.uid = i_uid
           AND mb.tab IS NOT NULL
         GROUP BY tab) AS r
      WHERE t.uid = i_uid
        AND t.tab = r.tab;

    UPDATE mail.box m
       SET newest_tif = true
     WHERE m.uid = i_uid
       AND mid IN (
        SELECT max(newest_mid) newest_mid
          FROM (
            SELECT fid, tid,
                   last_value(mid) over
                      (PARTITION BY fid, tid ORDER BY received_date
                      ROWS
                          BETWEEN UNBOUNDED PRECEDING
                              AND UNBOUNDED FOLLOWING)
                   AS newest_mid
              FROM mail.box
             WHERE uid = i_uid
               AND tid IS NOT NULL
          ) m
          GROUP by fid, tid);

    UPDATE mail.box m
       SET newest_tit = true
     WHERE m.uid = i_uid
       AND mid IN (
        SELECT max(newest_mid) newest_mid
          FROM (
            SELECT tab, tid,
                   last_value(mid) over
                      (PARTITION BY tab, tid ORDER BY received_date
                      ROWS
                          BETWEEN UNBOUNDED PRECEDING
                              AND UNBOUNDED FOLLOWING)
                   AS newest_mid
              FROM mail.box
             WHERE uid = i_uid
               AND tab IS NOT NULL
               AND tid IS NOT NULL
          ) m
          GROUP by tab, tid);
$$ LANGUAGE SQL;
