CREATE OR REPLACE FUNCTION util.fill_imap_chains(i_uid code.uid)
    RETURNS void AS $$
DECLARE
    chain_size smallint;
    rev_as_lock bigint := code.acquire_current_revision(i_uid);
BEGIN
    chain_size = impl.get_chain_size();

    WITH chained_box AS (
        SELECT * FROM (
            SELECT c.*,
                   max(imap_rownum) OVER (PARTITION BY fid) AS max_imap_rownum
              FROM (
                SELECT uid,
                       fid,
                       imap_id,
                       row_number() OVER (PARTITION BY fid ORDER BY imap_id) AS imap_rownum
                  FROM mail.box
                 WHERE uid = i_uid) c ) sb
             WHERE imap_rownum % chain_size = 1
    )
    UPDATE mail.box ub
       SET chain = least(chain_size, max_imap_rownum - imap_rownum + 1)
      FROM chained_box sb
     WHERE ub.uid = sb.uid
       AND ub.imap_id = sb.imap_id
       AND ub.fid = sb.fid;
END;
$$ LANGUAGE plpgsql;
