CREATE OR REPLACE FUNCTION util.fix_counters(
    i_uid code.uid,
    current_revision bigint
) RETURNS void AS $$
DECLARE
BEGIN
    UPDATE mail.counters c
       SET has_attaches_count = real_message_count,
           has_attaches_seen = real_message_seen,
           revision = current_revision
      FROM (
            SELECT COALESCE(count(*), 0) as real_message_count,
                   COALESCE(sum(seen::integer), 0) as real_message_seen,
                   COALESCE(max(revision), 0) as max_revision
              FROM mail.box mb
              JOIN mail.messages mm
                ON (mb.uid = mm.uid AND mb.mid=mm.mid)
             WHERE mb.uid = i_uid
               AND CARDINALITY(mm.attaches) > 0
               AND NOT impl.is_hidden_folder(impl.get_folder_type(i_uid, mb.fid)) ) r
    WHERE c.uid = i_uid
      AND (
           has_attaches_count != real_message_count
        OR has_attaches_seen != real_message_seen
        OR revision < max_revision);

    IF found THEN
        INSERT INTO mail.fix_log
            (uid, revision,
            fix_key, fixed)
        VALUES
            (i_uid, current_revision,
            'counters.fixed_attaches',
            '{}'::jsonb);
    END IF;
END;
$$ LANGUAGE plpgsql;
