CREATE OR REPLACE FUNCTION util.fix_doomed_layout(
    i_uid             code.uid,
    i_current_revison bigint
) RETURNS void AS $$
DECLARE
    fix_doomed_messages     integer := 0;
    fix_not_doomed_messages integer := 0;

BEGIN
    UPDATE mail.box
       SET doom_date = current_timestamp
     WHERE uid = i_uid
       AND doom_date IS NULL
       AND fid IN (
        SELECT fid
          FROM mail.folders f
         WHERE f.uid = i_uid
           AND code.is_doom_folder(f.type));

    GET DIAGNOSTICS fix_doomed_messages = ROW_COUNT;

    UPDATE mail.box
       SET doom_date = NULL
     WHERE uid = i_uid
       AND doom_date IS NOT NULL
       AND fid IN (
        SELECT fid
          FROM mail.folders f
         WHERE f.uid = i_uid
           AND NOT code.is_doom_folder(f.type));

    GET DIAGNOSTICS fix_not_doomed_messages = ROW_COUNT;

    IF fix_doomed_messages > 0 OR fix_not_doomed_messages > 0 THEN
        INSERT INTO mail.fix_log
            (uid, revision,
             fix_key, fixed)
        VALUES
            (i_uid, i_current_revison,
             'fix_doomed', json_build_object(
                'restore_doomed_on_doomed_messages', fix_doomed_messages,
                'remove_doomed_from_not_doomed_messages', fix_not_doomed_messages)::jsonb);
    END IF;
END;
$$ LANGUAGE plpgsql;
