CREATE OR REPLACE FUNCTION util.fix_revision(i_uid code.uid, current_revision bigint)
    RETURNS bigint AS $$
DECLARE
    biggest_revision     bigint;
    new_current_revision bigint;
BEGIN
    -- define biggest revision
    -- we want save or fixes on actual revision
    SELECT greatest(b_revision, l_revision, f_revision, cnt_revision, chain_revision, log_revision)
      INTO biggest_revision
      FROM (
        SELECT coalesce(max(revision), 0) AS b_revision
          FROM mail.box
         WHERE uid = i_uid) b, (
        SELECT coalesce(max(revision), 0) AS l_revision
          FROM mail.labels
         WHERE uid = i_uid) l, (
        SELECT coalesce(max(revision), 0) AS f_revision
          FROM mail.folders
         WHERE uid = i_uid) f, (
        SELECT revision AS cnt_revision
          FROM mail.counters
         WHERE uid = i_uid) c, (
        SELECT coalesce(max(revision), 0) AS chain_revision
          FROM mail.chained_log
         WHERE uid = i_uid) icl, (
        -- XXX: don't forget to fix it after
        -- change_log partitions
        SELECT coalesce(max(revision), 0) AS log_revision
          FROM mail.change_log
         WHERE uid = i_uid) cl;
    IF current_revision <= biggest_revision THEN
        new_current_revision := biggest_revision + 1;

        UPDATE mail.serials s
           SET next_revision = new_current_revision
         WHERE uid = i_uid;

        INSERT INTO mail.fix_log
            (uid, revision,
            fix_key, fixed)
        VALUES
            (i_uid, new_current_revision,
            'serials.next_revision',
            to_json(
                (current_revision, new_current_revision)::util.fix_delta
            )::jsonb);
        RETURN new_current_revision;
    END IF;
    RETURN current_revision;
END;
$$ LANGUAGE plpgsql;