CREATE OR REPLACE FUNCTION util.fix_serials(i_uid code.uid, current_revision bigint)
    RETURNS void AS $$
DECLARE
    i_fixed util.fix_delta_with_key[];
BEGIN
    WITH fixed_serials AS (
        UPDATE mail.serials s
           SET next_mid_serial = greatest(next_mid_serial, messages_max_serial + 1),
               next_lid = greatest(next_lid, max_lid + 1),
               next_fid = greatest(next_fid, max_fid + 1),
               next_owner_subscription_id
                       = greatest(next_owner_subscription_id, max_owner_subscription_id + 1),
               next_subscriber_subscription_id
                       = greatest(next_subscriber_subscription_id, max_subscriber_subscription_id + 1),
               next_collector_id = greatest(next_collector_id, max_collector_id + 1)
          FROM (
            SELECT coalesce(max(impl.mid2serial(mid)), 0) AS messages_max_serial
              FROM mail.messages
             WHERE uid = i_uid) m, (
            SELECT max(lid) AS max_lid
              FROM mail.labels
             WHERE uid = i_uid) l, (
            SELECT max(fid) AS max_fid
              FROM mail.folders
             WHERE uid = i_uid) f, (
            SELECT coalesce(max(subscription_id), 0) AS max_owner_subscription_id
              FROM mail.shared_folder_subscriptions
             WHERE uid = i_uid) osub, (
            SELECT coalesce(max(subscription_id), 0) AS max_subscriber_subscription_id
              FROM mail.subscribed_folders
             WHERE uid = i_uid) ssub, (
            SELECT coalesce(max(collector_id), 0) AS max_collector_id
              FROM mail.collectors
             WHERE uid = i_uid) coll
         WHERE uid = i_uid
        RETURNING s.*)
    SELECT ARRAY[
        ('next_mid_serial', (os.next_mid_serial, fs.next_mid_serial)),
        ('next_fid', (os.next_fid, fs.next_fid)),
        ('next_lid', (os.next_lid, fs.next_lid)),
        ('next_owner_subscription_id', (os.next_owner_subscription_id,
                                        fs.next_owner_subscription_id)),
        ('next_subscriber_subscription_id', (os.next_subscriber_subscription_id,
                                             fs.next_subscriber_subscription_id)),
        ('next_collector_id', (os.next_collector_id, fs.next_collector_id))
      ]::util.fix_delta_with_key[]
      INTO i_fixed
      FROM fixed_serials fs, mail.serials os
     WHERE os.uid = i_uid;

    INSERT INTO mail.fix_log
        (uid, revision, fix_key, fixed)
    SELECT
        i_uid, current_revision,
        'serials.' || (fd).key_name,
        to_json((fd).delta)::jsonb
      FROM unnest(i_fixed) fd
     WHERE ((fd).delta).old != ((fd).delta).new;

END;
$$ LANGUAGE plpgsql;
