CREATE OR REPLACE FUNCTION util.fix_tabs(i_uid code.uid, current_revision bigint)
    RETURNS void AS $$
DECLARE
BEGIN
    WITH td_up AS (
        UPDATE mail.tabs td
           SET message_count = real_message_count,
               message_seen = real_message_seen,
               message_size = real_message_size,
               attach_count = real_attach_count,
               attach_size = real_attach_size,
               revision = current_revision
          FROM (
            SELECT t.tab AS tab,
                   coalesce(real_message_count, 0) AS real_message_count,
                   coalesce(real_message_seen, 0) AS real_message_seen,
                   coalesce(real_message_size, 0) AS real_message_size,
                   coalesce(real_attach_count, 0) AS real_attach_count,
                   coalesce(real_attach_size, 0) AS real_attach_size,
                   coalesce(max_revision, 0) AS max_revision
              FROM mail.tabs t
              LEFT JOIN (
                SELECT uid,
                       tab,
                       count(*) as real_message_count,
                       sum(seen::integer) as real_message_seen,
                       sum(size) as real_message_size,
                       sum(coalesce(array_length(attaches, 1), 0)) as real_attach_count,
                       sum(code.get_attaches_size(attaches)) as real_attach_size,
                       max(revision) as max_revision
                  FROM mail.box mb
                  JOIN mail.messages mm
                 USING (uid, mid)
                 WHERE mb.uid = i_uid
                   AND mb.tab IS NOT NULL
                 GROUP BY uid, tab) tr
             USING (uid, tab)
             WHERE t.uid = i_uid) r
        WHERE td.uid = i_uid
          AND td.tab = r.tab
          AND (
               message_count != real_message_count
            OR message_seen != real_message_seen
            OR message_size != real_message_size
            OR attach_count != real_attach_count
            OR attach_size != real_attach_size
            OR revision < max_revision)
        RETURNING td.tab)
    INSERT INTO mail.fix_log
        (uid, revision,
        fix_key, fixed)
    SELECT
        i_uid, current_revision,
        'tabs.fixed_counters', to_json(fixed_tabs)::jsonb
      FROM (
        SELECT array_agg(tab) AS fixed_tabs
          FROM td_up) x
     WHERE cardinality(fixed_tabs) > 0;
END;
$$ LANGUAGE plpgsql;
