CREATE OR REPLACE FUNCTION util.fix_threads_newest_in_folders(
    i_uid               code.uid,
    current_revision    bigint
) RETURNS void AS $$
DECLARE
    fixed_tids       bigint[];
BEGIN
    -- Fix newest_tif
    -- Get newest_mids
    WITH newest_mids as (
        SELECT max(newest_mid) newest_mid
          FROM (
            SELECT fid, tid,
                   last_value(mid) over
                      (PARTITION BY fid, tid ORDER BY received_date
                      ROWS
                          BETWEEN UNBOUNDED PRECEDING
                              AND UNBOUNDED FOLLOWING)
                   AS newest_mid
              FROM mail.box
             WHERE uid = i_uid
               AND tid IS NOT NULL
          ) m
          GROUP by fid, tid
      ), upd AS (
        UPDATE mail.box m
           SET newest_tif = ml.new_newest_tif
          FROM (
            SELECT mid, (NOT newest_tif) as new_newest_tif
              FROM mail.box
              LEFT JOIN newest_mids as nm ON (box.mid = newest_mid)
             WHERE uid = i_uid
               AND (
                   (NOT newest_tif AND newest_mid is not null)
                OR (newest_tif AND newest_mid is null)
               )
         ) ml
         WHERE m.uid = i_uid
           AND m.mid = ml.mid
        RETURNING m.tid )
    SELECT array_agg(x.tid)
      INTO fixed_tids
      FROM (
          SELECT DISTINCT(upd.tid)
            FROM upd ) x;

    -- Log fixed
    IF COALESCE(cardinality(fixed_tids), 0) > 0 THEN
        INSERT INTO mail.fix_log
            (uid, revision,
            fix_key, fixed)
        VALUES
            (i_uid, current_revision,
            'box.newest_tif.fixed_threads', to_json(fixed_tids)::jsonb);
    END IF;
END;
$$ LANGUAGE plpgsql;
